// -*- c++ -*-

#include "ModuleMacros.h"

class MSetParameter : public Module
{
    friend class SSigSetParameter;
    Slot *slot_input;
    Slot *slot_parameter;

    SignalType parameter_signal_type;
    SignalType operand_signal_type;
    string parametername;
public:
    MSetParameter(SignalType parameter_signal_type, SignalType operand_signal_type,
		  string constructor_string);
    void setParameterName(string name);
    string getParameterName() const { return parametername; };
    string toString() const;
    string getName() const { return getName(parameter_signal_type, operand_signal_type); };
    /**
     * Helper function for computing the module's name that can be called
     * from MLSetParameter as well.
     */
    static string getName(SignalType parameter_signal_type, SignalType operand_signal_type);
};

