/***************************************************************************
                          docking.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// conf.cpp
// ktuner v0.1, by Carl van Schaik
// e-mail carl@leg.uct.ac.za

#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <stdio.h>
#include <qapp.h>
#include <qpixmap.h>
#include <qtimer.h>
#include <qpopmenu.h>
#include <qpoint.h>


class DockWidget : public QWidget {

  Q_OBJECT

public:
  DockWidget(const char *name=0);
  ~DockWidget();
  void setRadioState(int);
  void addMenuChannel(int,QString);
  void resetMenuChannels();

protected:
  void paintEvent(QPaintEvent *e);

signals:
  void sendOptions();
  void sendMute();
  void sendSleep();
  void sendAlarm();
  void sendRadio();
  void sendFreq(int);

private slots:
  void timeclick();
  void toggle_window_state();
  void mousePressEvent(QMouseEvent *e);
  void selectOptions();
  void selectMute();
  void selectSleep();
  void selectAlarm();
  void selectRadio();
  void selectFreq(int);

public slots:
  void dock();
  void undock();
  void paintIcon();

public:
  const bool isDocked();

private:
  bool docked;
  int toggleID;
  int pos_x,
      pos_y,
      sleepID,
      alarmID,
      radioID,
      radioState;
  QPopupMenu *popup_m,
             *channel_m;

  QPixmap small_pixmap,
          sleep_mask,
          alarm_mask,
          off_mask;

};

#endif

