/***************************************************************************
                          docking.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// docking.cpp
// ktuner v0.1, by Carl van Schaik
// e-mail carl@leg.uct.ac.za

//#include <qtooltip.h>
#include <kwm.h>
#include <kapp.h>

#include "docking.h"
#include <qmsgbox.h>
#include <qimage.h>
#include "dockicons.h"

extern KApplication *base;
extern QWidget *Panel;

DockWidget::DockWidget(const char *name)
  : QWidget(0, name, 0) {

  docked = false;
  
  pos_x = pos_y = 0;
  
  radioState=0;

  QImage temp1((const char**)kTuner_xpm);
  QImage temp2((const char**)kTuner_z_xpm);
  QImage temp3((const char**)kTuner_alarm_xpm);
  QImage temp4((const char**)kTuner_off_xpm);
  small_pixmap = temp1;
  sleep_mask = temp2;
  alarm_mask = temp3;
  off_mask = temp4;

  // popup menu for right mouse button
  popup_m = new QPopupMenu();
  channel_m = new QPopupMenu();
  connect(channel_m, SIGNAL(activated(int)), this, SLOT(selectFreq(int)));

  radioID = popup_m->insertItem(i18n("Radio On"), this, SLOT(selectRadio()));
  popup_m->insertItem(i18n("(Un)Mute"), this, SLOT(selectMute()));
  alarmID = popup_m->insertItem(i18n("Alarm On"), this, SLOT(selectAlarm()));
  sleepID = popup_m->insertItem(i18n("Sleep On"), this, SLOT(selectSleep()));
  popup_m->insertSeparator();

  channel_m->insertItem(i18n("Empty"));

  popup_m->insertItem(i18n("Channels"),channel_m);
  popup_m->insertItem(i18n("Options"), this, SLOT(selectOptions()));
  popup_m->insertSeparator();
  toggleID = popup_m->insertItem(i18n("Restore"), this, SLOT(toggle_window_state()));
  popup_m->insertItem(i18n("Close"), qApp, SLOT(quit()));

  //  QToolTip::add( this, statstring.data() );
  dock();
}

DockWidget::~DockWidget() {
}

void DockWidget::dock() {

  if (!docked) {


    // prepare panel to accept this widget
    KWM::setDockWindow (this->winId());

    // that's all the space there is
    this->setFixedSize(24, 24);

    // finally dock the widget
    this->show();
    docked = true;
  }
  if(Panel){
    QPoint point = Panel->mapToGlobal (QPoint (0,0));
    pos_x = point.x();
    pos_y = point.y();

  }
}

void DockWidget::undock() {

  if (docked) {

    // the widget's window has to be destroyed in order 
    // to undock from the panel. Simply using hide() is
    // not enough.
    this->destroy(true, true);

    // recreate window for further dockings
    this->create(0, true, false);

    docked = false;
  }
}

const bool DockWidget::isDocked() {

  return docked;

}

void DockWidget::paintEvent (QPaintEvent *e) {

  (void) e;

  paintIcon();

}

void DockWidget::paintIcon ()
{
  bitBlt(this, 2, 0, &small_pixmap );
}

void DockWidget::timeclick()
{
  if(this->isVisible())
    paintIcon();
}


void DockWidget::mousePressEvent(QMouseEvent *e)
{
  // open/close connect-window on right mouse button 
  if ( e->button() == LeftButton ) {
    toggle_window_state();
  }

  // open popup menu on left mouse button
  if ( e->button() == RightButton ) {//  || e->button() == MidButton) {
    int x = e->x() + this->x();
    int y = e->y() + this->y();

    QString text;
    if(Panel->isVisible())
      text = i18n("Minimize");
    else
      text = i18n("Restore");
    
    popup_m->changeItem(text, toggleID);
    popup_m->popup(QPoint(x-20, y-190));
    popup_m->exec();
  }
  if ( e->button() == MidButton )
    {
      selectMute();
    }
}

void DockWidget::toggle_window_state() {

  // restore/hide connect-window
  if(Panel != 0L)  {
    if (Panel->isVisible()){

     QPoint point = Panel->mapToGlobal (QPoint (0,0));
     pos_x = point.x();
     pos_y = point.y();
     Panel->hide();
    }
    else {
     Panel->setGeometry(
		 pos_x, 
		 pos_y,
		 Panel->width(),
		 Panel->height());

      Panel->show();
    }
  }
}

void DockWidget::setRadioState(int s)
{
  switch (s)
    {
    case 0:
      {
	if(this->isVisible()) { bitBlt(this, 2, 0, &alarm_mask, 0,0,-1,-1,XorROP); }
	popup_m->changeItem(i18n("Alarm On"), alarmID);
	break;
      }
    case 1:
      {
	if(this->isVisible()) { bitBlt(this, 2, 0, &alarm_mask, 0,0,-1,-1,XorROP); }
	popup_m->changeItem(i18n("Alarm Off"), alarmID);
	break;
      }
    case 2:
      {
	if(this->isVisible()) { bitBlt(this, 2, 0, &sleep_mask, 0,0,-1,-1,XorROP); }
	popup_m->changeItem(i18n("Sleep On"), sleepID);
	break;
      }
    case 3:
      {
	if(this->isVisible()) { bitBlt(this, 2, 0, &sleep_mask, 0,0,-1,-1,XorROP); }
	popup_m->changeItem(i18n("Sleep Off"), sleepID);
	break;
      }
    case 4:
      {
	if (radioState != 4)
	  {
	    if(this->isVisible()) { bitBlt(this, 2, 0, &off_mask, 0,0,-1,-1,XorROP); }
	    popup_m->changeItem(i18n("Radio On"), radioID);
	  }
	break;
      }
    case 5:
      {
	if (radioState != 5)
	  {
	    if(this->isVisible()) { bitBlt(this, 2, 0, &off_mask, 0,0,-1,-1,XorROP); }
	    popup_m->changeItem(i18n("Radio Off"), radioID);
	  }
	break;
      }
      default: {}
    }
  radioState = s;
}  

void DockWidget::selectOptions()
{
  emit sendOptions();
}

void DockWidget::selectMute()
{
  emit sendMute();
}

void DockWidget::selectSleep()
{
  emit sendSleep();
}

void DockWidget::selectAlarm()
{
  emit sendAlarm();
}

void DockWidget::selectRadio()
{
  emit sendRadio();
}

void DockWidget::addMenuChannel(int n,QString c)
{
  channel_m->insertItem(c,n);
}

void DockWidget::resetMenuChannels()
{
  channel_m->clear();
}

void DockWidget::selectFreq(int f)
{
  emit sendFreq(f);
}
