/***************************************************************************
                          conf.h  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// conf.h
// ktuner v0.5, by Carl van Schaik
// e-mail carl@leg.uct.ac.za
//
// Radiotrack II implementation : Leendert Meyer (leendert@usa.net).
//
// RadioTrack II Protocol : Ben Pfaff

#ifndef CONF_H
#define CONF_H

//#include <qapp.h>
#include <kconfig.h>

enum CardType { NONE, RADIOTRACK, RADIOTRACKII, ZOLTRIX, KERNELDEV };

class configFile
{
 public:
  configFile();

  int readin();
  int save();

  int getFreq(int);
  char* getName(int);

  void insChannel(int pos);
  void delChannel(int pos);

  int getNumMoreChannels();

  int getBasePort();
  int getDefault();
  GUIStyle gui();
  void setGui(GUIStyle);

  CardType getCardType();
  void setCardType(CardType);

  void setFreq(int, int);
  void setName(int, const char*);

  void setVolume(int);
  int getVolume();

  void setVerbose(bool);
  bool getVerbose();

  void setBasePort(int);
  void setDefault(int);

  int noVolSet();
  void setNoVolSet(int);
  int noDefSet();
  void setNoDefSet(int);

  int getSleepTime();
  void setSleepTime(int);

  int getAlarmHr();
  int getAlarmMin();
  void setAlarmTime(int Hr,int Min);

  int setAlarm();
  void setAlarmDef(int);

 private:
  //  int processString(char*);
  void delSlashN(char*);

  int numMore
      ,basePort
      ,volume
      ,defaultChannel
      ,alarmHr, alarmMin
      ,sleepT;
  bool verbose,
       noDefaultSet,
       noVolumeSet,
       alarmSet;
  GUIStyle guiStyle;
  CardType cardType;

  int channelFreq[9];
  int *moreFreq; // Dynamic array

  char* channelName[9];

  char* moreName[100];  //Dynamic array

  KConfig *conf;

  void newsave();
  void newread();
};

#endif
