/***************************************************************************
                          alarm.cpp  -  description
                             -------------------
    begin                : Thu Sep 30 1999
    copyright            : (C) 1999 by Ralf Nolden
    email                : Ralf.Nolden@post.rwth-aachen.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
// alarm.cpp
// ktuner v0.1 , Carl van Schaik
// e-mail carl@leg.uct.ac.za

#ifndef ALARM_CPP
#define ALARM_CPP

#include "alarm.h"

alarmClock::alarmClock(QObject *parent = 0, const char *name = 0)
{
  hour = 0;
  minute = 0;
  state = 0;
}

void alarmClock::setAlarm(int Hr, int Min)
{
  if ((Hr < 24) && (Hr >= 0) && (Min < 60) && (Min >= 0))
    {
      hour = Hr;
      minute = Min;
    }
}

void alarmClock::toggle()
{
  if (state == 0)
    {
      timer = startTimer( 10000 );  // 10 second intervals
      state = 1;
      stopTime = QTime::QTime(hour, minute);
    }
  else
    {
      killTimer(timer);
      state = 0;
    }
  emit onOff();
}

void alarmClock::timerEvent( QTimerEvent *e )
{
  if (state)
    {
      if ((stopTime.secsTo(QTime::currentTime()) < 10) && (stopTime.secsTo(QTime::currentTime()) >= 0))
	emit ring();
    }
}

#endif
