	/*

	Copyright (C) 1998 Stefan Westerfeld
                       stefan@space.twc.de

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    */

#include <stdio.h>
#include <math.h>
#include <stdlib.h>

main(int argc,char **argv)
{
	float frequency,outvol=1;
	long offset = 0;
	long len,i;
	long outval;
	unsigned char ov[2];

	if(argc < 3)
	{
		fprintf(stderr,"usage: %s <frequency> <len in seconds> <outvol> <offset to zero>\n",argv[0]);
		exit(1);
	}
	frequency = atof(argv[1]);
	printf("frequency is %f\n",frequency);
	len = atoi(argv[2]) * 44100;
	if(argc>3) outvol = atof(argv[3]);
	if(argc>4) offset = atoi(argv[4]);

	for(i=0;i<len;i++)
	{
		outval = sin((float)i/(44100/frequency)*2*M_PI)*32700*outvol+offset;
		outval += 65536;
//		printf("%d (%2.2g)\n",outval,((float)i/(44100.0/frequency)*2*M_PI));
		ov[0] = outval % 256;
		ov[1] = outval / 256;
		fwrite(ov,1,2,stdout);
	}
}
