/***************************************************************************
                          machine.c  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "machine.h"

void	writestr2(char *str,int i)
{
	char		*a;

	a = (char*)&i;
	str[0] = a[0];
	str[1] = a[1];
}

void	writestr4(char *str,int i)
{
	char		*a;

	a = (char*)&i;
	str[0] = a[0];
	str[1] = a[1];
	str[2] = a[2];
	str[3] = a[3];
}

int	make_be2(int i)
{
	char		*a,b[2];

	a = (char*)&i;
	b[0] = a[(BYTE_ORDER / 100 - 1) % 10];
	b[1] = a[(BYTE_ORDER / 1000 - 1) % 10];

	return (int)*(short*)b;
}

int	make_be4(int i)
{
	char		*a,b[4];

	a = (char*)&i;
	b[0] = a[(BYTE_ORDER / 1 - 1) % 10];
	b[1] = a[(BYTE_ORDER / 10 - 1) % 10];
	b[2] = a[(BYTE_ORDER / 100 - 1) % 10];
	b[3] = a[(BYTE_ORDER / 1000 - 1) % 10];

	return *(int*)b;
}
int	make_le2(int i)
{
	char		*a,b[2];

	a = (char*)&i;
	b[1] = a[(BYTE_ORDER / 100 - 1) % 10];
	b[0] = a[(BYTE_ORDER / 1000 - 1) % 10];

	return (int)*(short*)b;
}

int	make_le4(int i)
{
	char		*a,b[4];

	a = (char*)&i;
	b[3] = a[(BYTE_ORDER / 1 - 1) % 10];
	b[2] = a[(BYTE_ORDER / 10 - 1) % 10];
	b[1] = a[(BYTE_ORDER / 100 - 1) % 10];
	b[0] = a[(BYTE_ORDER / 1000 - 1) % 10];

	return *(int*)b;
}


