/***************************************************************************
                          ksoundwidget.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __KSOUNDWIDGET__
#define __KSOUNDWIDGET__

#include <qwidget.h>
#include <qpainter.h>
#include <qcursor.h>
#include <qbitmap.h>

#include <drag.h>

#include "csample.h"

#define KSW_NAREA	32


class KSoundWidget : public KDNDWidget
{
	Q_OBJECT
	friend class	KSoundWidgetPro;

public:

	KSoundWidget(QWidget *parent);
	KSoundWidget(QWidget *parent,int c,uint mode,int size = 1);
	KSoundWidget(QWidget *parent,CSample *s);
	KSoundWidget(QWidget *parent,CSample &s);
	~KSoundWidget();

	enum		Mode {Select,Zoom};

	void		setup();
	void		getColors(QColor *color);
	void		setColors(QColor *color);
	void		setDefaultColors();

	void		draw();
	void		draw(int);
	void		draw(int,int);
	void		draw(int,int,bool);

	void		resize(int size);
	void		resize(int w,int h);

	/** returns the selection start position (in samples) */
	int			getSelectionStart();
	/** returns the selection end position (in samples) */
	int			getSelectionEnd();
	/** sets the selection start position (in samples) */
	void			setSelectionStart(int,bool repaint = true);
	/** sets the selection end position (in samples) */
	void			setSelectionEnd(int,bool repaint = true);

	/** sets the display start position (in samples)
			and the display zoom */
	void			setDisplayValues(int ds,int dz,bool repaint = true);
	/** sets the display start position (in samples) */
	void			setDisplayStart(int ds,bool repaint = true);
	/** sets the display end position (in samples) */
	void			setDisplayEnd(int de,bool repaint = true);
	/** sets the display center position (in samples) */
	void			setDisplayCenter(int dc,bool repaint = true);
	/** sets the display zoom */
	void			setDisplayZoom(int dz,bool repaint = true);
	/** returns the display zoom */
	int				getDisplayZoom();
	/** returns the display start position (in samples) */
	int				getDisplayStart();
	/** returns the display end position (in samples) */
	int				getDisplayEnd();
	/** returns the display center position (in samples) */
	int				getDisplayCenter();

	/** returns the pointer position (in samples) */
	int				getPointer();
  /** sets the pointer position. If it lays outside the
			visible area, the visible area is moved. It returns true
			if the position is inside the sample, else it returns false
			and sets the pointer to the border of the sample. */
  bool			setPointer(int pos,bool repaint = true);

	void		setMode(KSoundWidget::Mode m);
	KSoundWidget::Mode	getMode();

	CSample	*getSample();

	int		getSampleRate();

	// bool		scroll(int pixel);

	void		drop(QMouseEvent *);

  /**  */
	int		screen2sample(int);
  /**  */
	int		sample2screen(int);
  /**  */
  bool isBusy();

private slots:
	void		droped(KDNDDropZone*);

signals:

	void		changedDisplayStart(int);
	void		changedDisplayZoom(int);
	void		gotDndURL(char *,int);
	
protected:
	void		layout();

	int			calcZoom(int l);
	int			calcZoom(int a,int b);
	int			maxZoom();

	bool		setDispStart(int ds);

	void		paintEvent(QPaintEvent *);
	void		resizeEvent(QResizeEvent *);
	void		mousePressEvent(QMouseEvent *);
	void		mouseReleaseEvent(QMouseEvent *);
	void		dndMouseMoveEvent(QMouseEvent *);
	void		dragEndEvent(void);
	void		timerEvent(QTimerEvent *);
	
protected:
	int				m_disp_start;
	int				m_disp_mode;
	int				m_disp_zoom;
	int				m_disp_start_old;
	int				m_sel_start,m_sel_end;
	int				m_zsel_start,m_zsel_end;
	int				m_pointer;

	QPainter	*painter;
	QBitmap		zoom_bitmap,zoom_mask;
	QCursor		zoom_cursor;

	KDNDDropZone	*dnddz;
	int				isdrag,startdrag;
	void			*dnddata;
	int				dndsize;

	QColor		bgcolor,fgcolor,nocolor,midlinecolor,devidecolor;
	QColor		sbgcolor,sfgcolor,smidlinecolor;
	QColor		pointercolor,spointercolor;
	QColor		zoomcolor;

	int				sel_on;
	int				first_mouse_pos,last_mouse_pos,mouse_left,mouse_right;
	int				xl,xr,lx,fx;
	int				scroll;
	
	CSample		*m_sample;

  /** indicates if the widget is busy */
  bool			m_busy;
  /** indicates if the widget is in selectionmode or zoommode */
	Mode			m_cursor_mode;
  /**  */
  bool			m_deletesample;

public slots: // Public slots
  /**  */
  void setBusy(bool busy);


};

#endif // KSOUNDWIDGET











