/***************************************************************************
                          kgraphedit.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "kgraphedit.h"

#include <stdio.h>

KGraphEdit::KGraphEdit(QWidget *parent=0,const char *name=0,double l=0.0,double r=1.0) :
	QWidget(parent,name)
{
	left = MAX(0,MIN(1,l));
	right = MAX(0,MIN(1,r));

	points.resize(0);
	painter = new QPainter(this);

	bgcolor.setRgb(255,255,255);
	linecolor.setRgb(0,0,0);
	pointcolor.setRgb(0,0,255);
	gridcolor.setRgb(200,200,200);

	sel = -1;
}

KGraphEdit::~KGraphEdit()
{
	points.resize(0);
	delete painter;
}

void	KGraphEdit::paintEvent(QPaintEvent *pe)
{
	if(pe == NULL) return;

	draw();
}

void	KGraphEdit::draw()
{
	int	t;
	int	xa,ya,xb,yb;
	int	w,h;
	double	xd,yd;

	w = width();
	h = height();

	//painter->setPen(bgcolor);
	//painter->drawRect(0,0,w,h);
	painter->fillRect(0,0,w,h,bgcolor);

	painter->setPen(gridcolor);
	for(t = 1;t < 10;t++)
	{
		painter->drawLine(0,h * t / 10,w,h * t / 10);
		painter->drawLine(w * t / 10,0,w * t / 10,h);
	}

	xa = 0;
	ya = (int)(left * (double)h);

	painter->setPen(pointcolor);
	if(pointshape)
		painter->drawRect(xa - 3,h - ya - 3,7,7);
	else
		painter->drawEllipse(xa - 3,h - ya - 3,7,7);

	for(t = 0;t < getNPoints();t++)
	{
		getPoint(t,&xd,&yd);
		xb = (int)(xd * (double)w);
		yb = (int)(yd * (double)h);

		painter->setPen(linecolor);
		painter->drawLine(xa,h - ya,xb,h - yb);

		xa = xb;
		ya = yb;

		painter->setPen(pointcolor);
		if(pointshape)
			painter->drawRect(xa - 3,h - ya - 3,7,7);
		else
			painter->drawEllipse(xa - 3,h - ya - 3,7,7);
	}
	xb = w;
	yb = (int)(right * (double)h);

	painter->setPen(linecolor);
	painter->drawLine(xa,h - ya,xb,h - yb);

	painter->setPen(pointcolor);
	if(pointshape)
		painter->drawRect(xb - 3,h - yb - 3,7,7);
	else
		painter->drawEllipse(xb - 3,h - yb - 3,7,7);
}

void	KGraphEdit::draw(int x,int y,int ww,int hh)
{
	int	t;
	int	xa,ya,xb,yb;
	int	w,h;
	double	xd,yd;

	w = width();
	h = height();

	painter->setClipRect(x,y,ww,hh);
	painter->setClipping(TRUE);
	painter->fillRect(x,y,ww + 1,hh + 1,bgcolor);

	painter->setPen(gridcolor);
	for(t = 1;t < 10;t++)
	{
		painter->drawLine(0,h * t / 10,w,h * t / 10);
		painter->drawLine(w * t / 10,0,w * t / 10,h);
	}

	xa = 0;
	ya = (int)(left * (double)h);

	painter->setPen(pointcolor);
	if(pointshape)
		painter->drawRect(xa - 3,h - ya - 3,7,7);
	else
		painter->drawEllipse(xa - 3,h - ya - 3,7,7);

	for(t = 0;t < getNPoints();t++)
	{
		getPoint(t,&xd,&yd);
		xb = (int)(xd * (double)w);
		yb = (int)(yd * (double)h);

		painter->setPen(linecolor);
		painter->drawLine(xa,h - ya,xb,h - yb);

		xa = xb;
		ya = yb;

		painter->setPen(pointcolor);
		if(pointshape)
			painter->drawRect(xa - 3,h - ya - 3,7,7);
		else
			painter->drawEllipse(xa - 3,h - ya - 3,7,7);
	}
	xb = w;
	yb = (int)(right * (double)h);

	painter->setPen(linecolor);
	painter->drawLine(xa,h - ya,xb,h - yb);

	painter->setPen(pointcolor);
	if(pointshape)
		painter->drawRect(xb - 3,h - yb - 3,7,7);
	else
		painter->drawEllipse(xb - 3,h - yb - 3,7,7);

	painter->setClipRect(0,0,w,h);
	painter->setClipping(FALSE);
}

void	KGraphEdit::sort()
{
	int	n,t,i;
	double	x,y;

	n = getNPoints();

	for(t = 1;t < n;t++)
	{
		for(i = 0;i < t;i++)
		{
			if(points[t * 2] < points[i * 2])
			{
				x = points[t * 2];
				y = points[t * 2 + 1];
				points[t * 2] = points[i * 2];
				points[t * 2 + 1] = points[i * 2 + 1];
				points[i * 2] = x;
				points[i * 2 + 1] = y;
			}
		}
	}
}

void	KGraphEdit::setLeftPoint(double l)
{
	left = MIN(1,MAX(0,l));
	draw();
}

double	KGraphEdit::getLeftPoint()
{
	return left;
}

void	KGraphEdit::setRightPoint(double r)
{
	right = MIN(1,MAX(0,r));
	draw();
}

double	KGraphEdit::getRightPoint()
{
	return right;
}

void	KGraphEdit::addPoint(double x,double y)
{
	int		t;

	x = MIN(1,MAX(0,x));
	y = MIN(1,MAX(0,y));

	for(t = 0;t < getNPoints();t++)
	{
		if(x == points[t * 2]) return;
	}

	points.resize(points.size() + 2);
	points[points.size() - 2] = x;
	points[points.size() - 1] = y;

	sort();

	draw();
}

int	KGraphEdit::delPoint(double x,double y)
{
	int		t;

	x = MIN(1,MAX(0,x));
	y = MIN(1,MAX(0,y));

	for(t = 0;t < getNPoints();t++)
	{
		if(x == points[t * 2] && y == points[t * 2 + 1])
		{
			points[t * 2] = 2;

			sort();

			points.resize(points.size() - 2);

			draw();

			return !0;
		}
	}

	return 0;
}

void	KGraphEdit::getPoint(int p,double *x,double *y)
{
	if(p < 0)
	{
		*x = 0;
		*y = left;

		return;
	}
	if(p >= getNPoints())
	{
		*x = 1;
		*y = right;

		return;
	}

	*x = points[p * 2];
	*y = points[p * 2 + 1];
}

int	KGraphEdit::getNPoints()
{
	return points.size() / 2;
}

double	KGraphEdit::getValue(double x)
{
	int	t;
	double	xa,ya,xb,yb;
	double	xd,yd;
	double	y,d;

	x = MIN(1,MAX(0,x));

	xa = 0;
	ya = left;

	for(t = 0;t < getNPoints();t++)
	{
		getPoint(t,&xd,&yd);
		xb = xd;
		yb = yd;

		if(x >= xa && x <= xb)
		{
			d = (yb - ya) / (xb - xa);
			y = ya + d * (x - xa);

			return y;
		}

		xa = xb;
		ya = yb;
	}
	xb = 1;
	yb = right;

	d = (yb - ya) / (xb - xa);
	y = ya + d * (x - xa);

	return y;
}	

void	KGraphEdit::reset()
{
	points.resize(0);
	left = 0.0;
	right = 1.0;
}

void	KGraphEdit::setBackgroundColor(QColor qc)
{
	bgcolor = qc;
}

QColor	KGraphEdit::getBackgroundColor()
{
	return bgcolor;
}

void	KGraphEdit::setLineColor(QColor qc)
{
	linecolor = qc;
}

QColor	KGraphEdit::getLineColor()
{
	return linecolor;
}

void	KGraphEdit::setGridColor(QColor qc)
{
	gridcolor = qc;
}

QColor	KGraphEdit::getGridColor()
{
	return gridcolor;
}

void	KGraphEdit::setPointColor(QColor qc)
{
	pointcolor = qc;
}

QColor	KGraphEdit::getPointColor()
{
	return pointcolor;
}

void    KGraphEdit::mousePressEvent(QMouseEvent *me) 
{ 
        int             t,i=-1; 
        double          x,y,d,m; 
 
        x = (double)me->x() / width(); 
        y = 1.0 - (double)me->y() / height(); 
 
        if(me->button() == RightButton) // add point
        { 
                addPoint(x,y); 
        } 
        if(me->button() == LeftButton || me->button() == RightButton) // move point 
        { 
 
                m = 2; 
		d = sqrt(SQR(x - 0) + SQR(y - left)); 
		if(d < m) 
		{ 
			i = -2; 
			m = d; 
		} 
		d = sqrt(SQR(x - 1) + SQR(y - right)); 
		if(d < m) 
		{ 
			i = -3; 
			m = d; 
		} 
                for(t = 0;t < getNPoints();t++) 
                { 
                        d = sqrt(SQR(x - points[t * 2]) + SQR(y - points[t * 2 + 1])); 
                        if(d < m) 
                        { 
                                i = t; 
                                m = d; 
                        } 
                } 
 
                if(m < 0.1) 
                { 
                        sel = i; 
			if(sel == -2)
				movePoint(0,left,0,y); 
			else if(sel == -3)
				movePoint(1,right,1,y); 
			else movePoint(points[sel * 2],points[sel * 2 + 1],x,y); 
                } 
        } 
        else if(me->button() == MidButton) // delete point
        { 
                m = 2; 
                for(t = 0;t < getNPoints();t++) 
                { 
                        d = sqrt(SQR(x - points[t * 2]) + SQR(y - points[t * 2 + 1])); 
                        if(d < m) 
                        { 
                                i = t; 
                                m = d; 
                        } 
                } 
 
                if(m < 0.1) 
                { 
                        sel = -1; 
                        delPoint(points[i * 2],points[i * 2 + 1]); 
                } 
        } 
 
        draw(); 
} 
 
void    KGraphEdit::mouseReleaseEvent(QMouseEvent *me) 
{ 
        double          x,y; 
 
        x = (double)me->x() / width(); 
        y = 1.0 - (double)me->y() / height(); 

        if(sel < 0)
	{
		if(sel == -1) return; 
		if(sel == -2)
			movePoint(0,left,0,y); 
		else if(sel == -3)
			movePoint(1,right,1,y); 
	}
	else
		movePoint(points[sel * 2],points[sel * 2 + 1],x,y); 
 
        sel = -1; 
 
        //draw(); 
} 
 
void    KGraphEdit::mouseMoveEvent(QMouseEvent *me) 
{ 
        double          x,y; 
 
        x = (double)me->x() / width(); 
        y = 1.0 - (double)me->y() / height(); 

        if(sel < 0)
	{
		if(sel == -1) return; 
		if(sel == -2)
			movePoint(0,left,0,y); 
		else if(sel == -3)
			movePoint(1,right,1,y); 
	}
	else
		movePoint(points[sel * 2],points[sel * 2 + 1],x,y); 
 
	//draw(); 
} 
 
int    KGraphEdit::movePoint(double xo,double yo,double xn,double yn) 
{ 
        int     t; 
 
	yn = MIN(1,MAX(0,yn));

	if(xo == 0)
	{
		left = yn;

		draw();

		return !0;
	}
	if(xo == 1)
	{
		right = yn;

		draw();

		return !0;
	}
        for(t = 0;t < getNPoints();t++) 
        { 
                if(points[t * 2] == xo && points[t * 2 + 1] == yo) 
                { 
                        // test if posible move 

			// test sides left and right
 			if(xn <= 0) xn = 0.00000001;
			if(xn >= 1) xn = 1 - 0.00000001;

			if(t > 0)
			{
				if(xn <= points[(t - 1) * 2])
					xn = points[(t - 1) * 2] + 0.00000001;
			}
			if(t < getNPoints() - 1)
			{
				if(xn >= points[(t + 1) * 2])
					xn = points[(t + 1) * 2] - 0.00000001;
			}

                        points[t * 2] = xn; 
                        points[t * 2 + 1] = yn; 
 
			double	minx,miny,maxx,maxy;

			minx = 1;
			miny = 1;
			maxx = 0;
			maxy = 0;
			if(t == 0)
			{
				minx = MIN(minx,0);
				miny = MIN(miny,MIN(left,points[1]));
				maxx = MAX(maxx,points[0]);
				maxy = MAX(maxy,MAX(left,points[1]));
			}
			if(t == getNPoints() - 1)
			{
				minx = MIN(minx,points[t * 2]);
				miny = MIN(miny,MIN(right,points[t * 2 + 1]));
				maxx = MAX(maxx,1);
				maxy = MAX(maxy,MAX(right,points[t * 2 + 1]));
			}
			//if(!(t == getNPoints() - 1)&&!(t == 0))
			{
				if(t > 0)
				{
					minx = MIN(minx,points[(t - 1) * 2]);
					miny = MIN(miny,MIN(points[(t - 1) * 2 + 1],points[t * 2 + 1]));
					maxx = MAX(maxx,points[t * 2]);
					maxy = MAX(maxy,MAX(points[(t - 1) * 2 + 1],points[t * 2 + 1]));
				}
				if(t < getNPoints() - 1)
				{
					minx = MIN(minx,points[t * 2]);
					miny = MIN(miny,MIN(points[(t + 1) * 2 + 1],points[t * 2 + 1]));
					maxx = MAX(maxx,points[(t + 1) * 2]);
					maxy = MAX(maxy,MAX(points[(t + 1) * 2 + 1],points[t * 2 + 1]));
				}
			}

			miny = MIN(miny,yo);
			maxy = MAX(maxy,yo);

			miny = 1 - miny;
			maxy = 1 - maxy;

			minx *= (double)width();
			miny *= (double)height();
			maxx *= (double)width();
			maxy *= (double)height();

			//printf("repaint(%i,%i),(%i,%i)\n",(int)minx,(int)maxy,(int)maxx - (int)minx,(int)miny - (int)maxy);
			draw((int)minx - 4,(int)maxy - 4,(int)maxx - (int)minx + 9,(int)miny - (int)maxy + 9);

                        return !0; 
                } 
        } 
	return 0;
}

