/***************************************************************************
                          csample.h  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef __CSAMPLE_H__
#define __CSAMPLE_H__

#include <stdio.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>

#include <sys/soundcard.h>


#include <qstring.h>


#include "machine.h"
#include "carray.h"

#ifndef NULL
#define NULL 0
#endif

#define	INT2D(a)	((double)(a) / 214783648.0)
#define	SHORT2D(a)	((double)(a) / 32768.0)
#define	CHAR2D(a)	((double)(a) / 128.0)
#define	FLOAT2D(a)	((double)(a))

#define CUT(a)		(MIN(1,MAX(-1,(a))))
#define	D2CHAR(a)	((char)(CUT(a) * 127.0))
#define	D2SHORT(a)	((short)(CUT(a) * 32767.0))
#define	D2INT(a)	((int)(CUT(a) * 214783647.0))
#define	D2FLOAT(a)	((float)(a))

#define BUFFERSIZE	1048576

enum	{
		SMPFLAGS_TYPE_8 = 0,
		SMPFLAGS_TYPE_16,
		SMPFLAGS_TYPE_32,
		SMPFLAGS_TYPE_FL,
		SMPFLAGS_TYPE_DB,
		SMPFLAGS_TYPEMASK = 1 | 2 | 3 | 4
	};
	
#ifndef MIN
#define MIN(a,b)	((a)<(b)?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b)	((a)>(b)?(a):(b))
#endif

#ifndef uint
typedef unsigned int uint;
#endif

#ifndef ushort
typedef unsigned short ushort;
#endif


typedef union
{
	CArray<char>	*d8;
	CArray<short>	*d16;
	CArray<int>	*d32;
	CArray<float>	*dfl;
	CArray<double>	*ddb;
}
sampledata;

class CSample
{
protected:
	uint								len;
	uint								rate;
	ushort							pitch;
	ushort							pitch_min,pitch_max;
	char								*name;
	uint								loop[3];
	uint								sample_mode;
	CArray<sampledata>	data;

public:
	CSample();
	CSample(uint c);
	CSample(uint c,uint mode,uint size);
	CSample(CSample *s);
	CSample(CSample &s);
	~CSample();

	void		setName(char *n);
	char*		getName();
	void		setRate(int r);
	int			getRate();
	void		setPitch(ushort p);
	ushort	getPitch();
	void		setPitchRange(ushort min,ushort max);
	ushort	getPitchMin();
	ushort	getPitchMax();
	uint		getLength();

	bool		isMono();
	bool		isStereo();
	int			getNChannel();

	int			addChannel();
	int			addChannel(uint n);
	int			delChannel(uint n);
	int			clear();

	bool		isType8();
	bool		isType16();
	bool		isType32();
	bool		isTypeFL();
	bool		isTypeDB();

	uint		getType()
	{
		return sample_mode;
	};

	void		convertToTypeDB();

	void		convertToType8();
	void		convertToType16();
	void		convertToType32();
	void		convertToTypeFL();
	
	void		convertTypeDBToType8();
	void		convertTypeDBToType16();
	void		convertTypeDBToType32();
	void		convertTypeDBToTypeFL();

	int			resize(uint size);

	int			get(uint c,uint pos,uint len,char *d8);
	int			get(uint c,uint pos,uint len,short *d16);
	int			get(uint c,uint pos,uint len,int *d32);
	int			get(uint c,uint pos,uint len,float *dfl);
	int			get(uint c,uint pos,uint len,double *ddb);
	int			get(uint c,uint pos,uint len,CSample *s);
	int			get(uint pos,uint len,CSample *s);
	int			get(uint c,uint pos,uint len,CSample &s);
	int			get(uint pos,uint len,CSample &s);

	int			set(uint c,uint pos,uint len,char *d8);
	int			set(uint c,uint pos,uint len,short *d16);
	int			set(uint c,uint pos,uint len,int *d32);
	int			set(uint c,uint pos,uint len,float *dfl);
	int			set(uint c,uint pos,uint len,double *ddb);
	int			set(uint c,uint pos,uint len,CSample *s);
	int			set(uint pos,uint len,CSample *s);
	int			set(uint c,uint pos,uint l,CSample *s,uint sc);
	int			set(uint c,uint pos,uint len,CSample &s);
	int			set(uint pos,uint len,CSample &s);
	int			set(uint c,uint pos,uint l,CSample &s,uint sc);

	int			move(uint dest,uint src,int len);

/*
	int			insert(uint pos,uint len,char*);
	int			insert(uint pos,uint len,short*);
	int			insert(uint pos,uint len,int*);
	int			insert(uint pos,uint len,float*);
	int			insert(uint pos,uint len,double*);
*/
	int			insert(uint pos,uint len,CSample *s);
	int			insert(uint pos,CSample *s);
	int			insert(uint pos,uint len,CSample &s);
	int			insert(uint pos,CSample &s);

	int			cut(uint pos,uint len,CSample *s = 0);
	int			cut(uint pos,uint len,CSample &s);

	int			loadWave(const char *fn);
	int			saveWave(const char *fn);

	void		setSample(CSample *s);
	void		setSample(CSample &s);

	void		equalize(CSample *s);
	void		equalize(CSample &s);

  /** Swaps the both channels n1 and n2 */
  void		swapChannel(int n1,int n2);

public:
	int			play();
	int			play(double,double);
	int			play(uint,uint);
	int			playback();
	int			playback(double,double);
	int			playback(uint,uint);
	int			playbackevent();
	void		stop();
	uint		currentPlayPos();
	double	currentPlayTime();
	int			playing();

	QString	getAudioDevice(int n = 0);
	void		setAudioDevice(QString,int n = 0);
  /**  */
  int 		bufferSize();
  /** returns the number of samples to write per playevent call */
  int writeSamples();
  /** sets the number of samples to write per playevent call */
  void setWriteSamples(int);

private:
	int				dsp_speed;
	int				dsp_stereo;
	int				dsp_samplesize;
	int				buffer_size;
	int				audio[2];
	QString		audio_dev[2];
	void			*buffer[2],*rb[2],*lb[2];
  /** keeps the number of samples to write per
			playevent call */
  int 			m_writesamples;
	uint			spb;
	uint			start_pos,end_pos,current_pos;
};



#endif





