/***************************************************************************
                          afx.cpp  -  description
                             -------------------
    begin                : Sun Dec 26 1999
    copyright            : (C) 1999 by Tobias Wollgam
    email                : Tobias.Wollgam@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "afx.h"

#include <math.h>
//#include <rfftw.h>

#define	PROGRESS(a,b,c,d)	(progress = 1.0 - ((double)(a) / (double)(b)) * (double)(c) / (double)(d));
#define INDICATE(a,b)		

/*
static int	afx_getmem(int want,void **mem)
{
	int		get;

	get = want;
	while((*mem = malloc(get)) == 0)
	{
		get = get * 2 / 3;
	}

	return get;
}
*/

double	CAFX::afxfn(double x,QArray<double> points,int sym)
{
	uint	t;
	double	xa,ya,xb,yb;
	double	xd,yd;
	double	y,d,xx,xs;

	sym = !sym;
	xx = MIN(1.0,fabs(x));
	xs = MIN(1,MAX(0,(x + 1.0) / 2.0));

	xa = points[0];
	ya = points[1];

	for(t = 1;t < (points.size() / 2) - 1;t++)
	{
		xd = points[t * 2];
		yd = points[t * 2 + 1];
		xb = xd;
		yb = yd;

		if(sym)
		{
			if(xs >= xa && xs <= xb)
			{
				d = (yb - ya) / (xb - xa);
				y = ya + d * (xs - xa);

				//printf("%f => %f\n",x,y);
				return y * 2.0 - 1.0;
			}
		}
		else
		{
			if(xx >= xa && xx <= xb)
			{
				d = (yb - ya) / (xb - xa);
				y = ya + d * (xx - xa);

				//printf("%f => %f\n",x,y);
				return y * SIGN(x);
			}
		}

		xa = xb;
		ya = yb;
	}
	xb = points[points.size() - 2];
	yb = points[points.size() - 1];

	if(sym)
	{
		d = (yb - ya) / (xb - xa);
		y = ya + d * (xs - xa);

		//printf("%f => %f\n",x,y);
		return y * 2.0 - 1.0;
	}

	d = (yb - ya) / (xb - xa);
	y = ya + d * (xx - xa);

	//printf("%f => %f\n",x,y);
	return y * SIGN(x);
}

double	CAFX::afxcompress(double x,double level)
{
	double		xus;
	double		xsign;

	level = MAX(level,0.000000001);

	xsign = SIGN(x);
	xus = x / xsign;

	return xsign * pow(xus,1 - level);
}

double	CAFX::afxexpand(double x,double level)
{
	double		xus;
	double		xsign;

	level = MAX(level,0.000000001);

	xsign = SIGN(x);
	xus = x / xsign;

	return xsign * pow(xus,1 / (1 - level));
}

void	CAFX::deeppass(CSample *smp,double c,double r,uint pos,uint len)
{
	uint		t,cn;
	double		a,d;

	module = "deeppass";
	
	if(smp == 0) return;
	if(smp->isType8())
	{
		double		h;
		int		i;
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			if(c != 0 && r != 0) a = exp(-((double)smp->getRate() / (r * c)));
			else a = 0;

			i = s[0];
			d = (double)i;
			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t == len - 1) h = 0;
				else h = s[t + 1];
				/*i = ((i * 8) / 8 + h) / 2;*/
				d = (d * a + (double)h) / 2.0;
				i = (int)d;
				s[t] = MAX(-128,MIN(i,127));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		double		h;
		int		i;
		short		*s;

		//if((n = (short*)malloc(smp->getLength() * 2)) == 0) return;
		
		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			if(c != 0 && r != 0) a = exp(-((double)smp->getRate() / (r * c)));
			else a = 0;

			//i = 32768 - (unsigned short)s[0];
			i = s[0];
			d = (double)i;
			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t == len - 1) h = 0;
				else h = s[t + 1];
				/*i = ((i * 8) / 8 + h) / 2;*/
				d = (d * a + (double)h) / 2.0;
				i = (int)d;
				s[t] = MAX(-32768,MIN(i,32767));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		double		h;
		int		i;
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			if(c != 0 && r != 0) a = exp(-((double)smp->getRate() / (r * c)));
			else a = 0;

			i = s[0];
			d = (double)i;
			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t == len - 1) h = 0;
				else h = s[t + 1];
				/*i = ((i * 8) / 8 + h) / 2;*/
				d = (d * a + (double)h) / 2.0;
				i = (int)d;
				s[t] = MAX(-214783648,MIN(i,214783647));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		double		i,h;
		float		*s;
		
		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			if(c != 0 && r != 0) a = exp(-((double)smp->getRate() / (r * c)));
			else a = 0;

			d = s[0];
			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t == len - 1) h = 0;
				else h = s[t + 1];
				d = (d * a + h) / 2.0;
				i = (int)d;
				s[t] = i;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		i,h;
		double		*s;
		
		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			if(c != 0 && r != 0) a = exp(-((double)smp->getRate() / (r * c)));
			else a = 0;

			d = s[0];
			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t == len - 1) h = 0;
				else h = s[t + 1];
				d = (d * a + h) / 2.0;
				i = (int)d;
				s[t] = i;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::highpass(CSample *smp,double c,double r,uint pos,uint len)
{
	CSample		*smpt;
	uint		t,cn;
	
	if(smp == 0) return;

	smpt = new CSample(smp);
	
	CAFX::deeppass(smpt,c,r,pos,len);
	
	module = "deeppass";

	if(smp->isType8())
	{
		char		*s,*st;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;
		if((st = (char*)malloc(len * sizeof(char))) == 0)
		{
			free(s);
			delete smpt;
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);
			smpt->get(cn,pos,len,st);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] = MAX(-127,MIN(s[t] - st[t],127));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(st);
	}
	if(smp->isType16())
	{
		short		*s,*st;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;
		if((st = (short*)malloc(len * sizeof(short))) == 0)
		{
			free(s);
			delete smpt;
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);
			smpt->get(cn,pos,len,st);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] = MAX(-32767,MIN(s[t] - st[t],32767));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(st);
	}
	if(smp->isType32())
	{
		int		*s,*st;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;
		if((st = (int*)malloc(len * sizeof(int))) == 0)
		{
			free(s);
			delete smpt;
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);
			smpt->get(cn,pos,len,st);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] = MAX(-214783648,MIN(s[t] - st[t],214783647));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(st);
	}
	if(smp->isTypeFL())
	{
		float		*s,*st;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;
		if((st = (float*)malloc(len * sizeof(float))) == 0)
		{
			free(s);
			delete smpt;
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);
			smpt->get(cn,pos,len,st);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] -= st[t];
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(st);
	}
	if(smp->isTypeDB())
	{
		double		*s,*st;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;
		if((st = (double*)malloc(len * sizeof(double))) == 0)
		{
			free(s);
			delete smpt;
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);
			smpt->get(cn,pos,len,st);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] -= st[t];
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(st);
	}

	delete smpt;
}

double	CAFX::calcVolume(CSample *smp,int pos,uint len)
{
	uint		t,cn;
	double		maxvol,d;

	module = "calc volume";

	maxvol = 0;

	if(smp == 0) return 0;
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = fabs((double)s[t] / 128);
				if(d > maxvol) maxvol = d;
			}
		}
		free(s);
		return maxvol;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = fabs((double)s[t] / 32768);
				if(d > maxvol) maxvol = d;
			}
		}
		free(s);
		return maxvol;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = fabs((double)s[t] / (32768 * 65536));
				if(d > maxvol) maxvol = d;
			}
		}
		free(s);
		return maxvol;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = fabs((double)s[t]);
				if(d > maxvol) maxvol = d;
			}
		}
		free(s);
		return maxvol;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = fabs(s[t]);
				if(d > maxvol) maxvol = d;
			}
		}
		free(s);
		return maxvol;
	}

	return 0;
}

void	CAFX::volume(CSample *smp,int pos,uint len)
{
	double		maxvol;

	if(smp == 0) return;
	if(len == 0) return;

	maxvol = calcVolume(smp,pos,len);

	volume(smp,1 / maxvol,pos,len);
}

double	CAFX::calcDCOffset(CSample *smp,int pos,uint len)
{
	uint		t,cn;
	double		delta;

	module = "calc offset";

	delta = 0;

	if(smp == 0) return 0;
	if(len == 0) return 0;
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				delta += (double)s[t];
			}
		}
		delta /= (double)len;
		free(s);

		return delta;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				delta += (double)s[t];
			}
		}
		delta /= (double)len;
		free(s);
		return delta;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				delta += (double)s[t];
			}
		}
		delta /= (double)len;
		free(s);
		return delta;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				delta += (double)s[t];
			}
		}
		delta /= (double)len;
		free(s);
		return delta;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return 0;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				delta += s[t];
			}
		}
		delta /= (double)len;
		free(s);
		return delta;
	}

	return 0;
}

void	CAFX::offsetDC(CSample *smp,double offset,int pos,uint len)
{
	uint		t,cn;
	double		d,delta;

	module = "offset";

	delta = offset;

	if(smp == 0) return;
	if(len == 0) return;
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		if(delta < 1) delta = 0;
		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] - delta;
				s[t] = (char)MAX(-127.0,MIN(d,127.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] - delta;
				s[t] = (short)MAX(-32767,MIN(d,32767));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] - delta;
				s[t] = (int)MAX(-214783647,MIN(d,214783647));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] - delta;
				s[t] = (float)d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] -= delta;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}
void	CAFX::optimizeDCOffset(CSample *smp,int pos,uint len)
{
	double		delta;

	if(smp == 0) return;
	if(len == 0) return;

	delta = calcDCOffset(smp,pos,len);

	offsetDC(smp,delta,pos,len);
}

void	CAFX::volume(CSample *smp,double vol,int pos,uint len)
{
	uint		t,cn;
	double		d;

	module = "volume";

	if(smp == 0) return;
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] * vol;
				s[t] = (char)MAX(-127.0,MIN(d,127.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] * vol;
				s[t] = (short)MAX(-32767,MIN(d,32767));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] * vol;
				s[t] = (int)MAX(-214783647,MIN(d,214783647));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] * vol;
				s[t] = (float)d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				s[t] *= vol;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::volume(CSample *smp,QArray<double> points,int pos,uint len)
{
	uint		t,cn;
	double		d;

	module = "volume";

	if(smp == 0) return;
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = CHAR2D(s[t]);
				d *= afxfn((double)t / (double)len,points,TRUE);
				s[t] = D2CHAR(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = SHORT2D(s[t]);
				d *= afxfn((double)t / (double)len,points,TRUE);
				s[t] = D2SHORT(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = INT2D(s[t]);
				d *= afxfn((double)t / (double)len,points,TRUE);
				s[t] = D2INT(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = FLOAT2D(s[t]);
				d *= afxfn((double)t / (double)len,points,TRUE);
				s[t] = D2FLOAT(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = s[t];
				d *= afxfn((double)t / (double)len,points,TRUE);
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::echo(CSample *smp,double delay,double volume,double release,uint pos,uint len)
{
	uint		t,cn,flen;
	double		d,*fifo;
	
	module = "echo";

	if(smp == 0) return;

	flen = (uint)(delay * (double)smp->getRate());
	if((fifo = (double*)malloc(flen * sizeof(double))) == 0) return;
	for(t = 0;t < flen;t++)
	{
		fifo[t] = 0;
	}


	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0)
		{
			free(fifo);
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] + fifo[t % flen];
				fifo[t % flen] = d * volume * (1 - (t / len)) / release;
				s[t] = (char)MAX(-127.0,MIN(d,127.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(fifo);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0)
		{
			free(fifo);
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] + fifo[t % flen];
				fifo[t % flen] = d * volume * (1 - (t / len)) / release;

				s[t] = (short)MAX(-32767.0,MIN(d,32767.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(fifo);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0)
		{
			free(fifo);
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] + fifo[t % flen];
				fifo[t % flen] = d * volume * (1 - (t / len)) / release;
				s[t] = (int)MAX(-214783647.0,MIN(d,214783647.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(fifo);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0)
		{
			free(fifo);
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] + fifo[t % flen];
				fifo[t % flen] = d * volume * (1 - (t / len)) / release;
				s[t] = (float)d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(fifo);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0)
		{
			free(fifo);
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = s[t] + fifo[t % flen];
				fifo[t % flen] = d * volume * (1 - (t / len)) / release;
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		free(fifo);
		return;
	}
}

void	CAFX::reverb(CSample *smp,double delay,double vol,double mix,uint pos,uint len)
{
	uint		t,cn,flen;
	double		d;
	
	module = "reverb";

	if(smp == 0) return;

	flen = (uint)(delay * (double)smp->getRate());

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0)
			return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t >= flen)
					d = CHAR2D(s[t]) * vol + mix * CHAR2D(s[t - flen]);
				else
					d = CHAR2D(s[t]) * vol;
				s[t] = D2CHAR(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0)
			return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t >= flen)
					d = SHORT2D(s[t]) * vol + mix * SHORT2D(s[t - flen]);
				else
					d = SHORT2D(s[t]) * vol;
				s[t] = D2SHORT(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0)
			return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t >= flen)
					d = INT2D(s[t]) * vol + mix * INT2D(s[t - flen]);
				else
					d = INT2D(s[t]) * vol;
				s[t] = D2INT(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0)
			return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				if(t >= flen)
					d = FLOAT2D(s[t]) * vol + mix * FLOAT2D(s[t - flen]);
				else
					d = FLOAT2D(s[t]) * vol;
				s[t] = D2FLOAT(d);
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0)
		{
			return;
		}

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				// out(x) = a * in(x) + b * out(x-t)
				if(t >= flen)
					d = s[t] * vol + mix * s[t - flen];
				else
					d = s[t] * vol;
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::fuzz(CSample *smp,double volume,double cut,int side,uint pos,uint len)
{
	uint		t,cn;
	double		d,delta;
	
	module = "fuzz";

	if(smp == 0) return;

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] / 128.0;
				if(d > volume)
				{
					delta = d - volume + 1;
					d = volume + pow(delta,cut) - 1;
				}
				if(side == 1)
				{
					if(d < -volume)
					{
						delta = volume + d + 1;
						d = -volume - pow(delta,cut) + 1;
					}
				}
				s[t] = (char)MAX(-127.0,MIN(d * 127,127.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] / 32768.0;
				if(d > volume)
				{
					delta = d - volume;
					d = volume + pow(delta,cut);
				}
				if(side == 1)
				{
					if(d < -volume)
					{
						delta = volume + d;
						d = -volume - pow(delta,cut);
					}
				}
				s[t] = (short)MAX(-32767.0,MIN(d * 32767,32767.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t] / 214783648.0;
				if(d > volume)
				{
					delta = d - volume;
					d = volume + pow(delta,cut);
				}
				if(side == 1)
				{
					if(d < -volume)
					{
						delta = volume + d;
						d = -volume - pow(delta,cut);
					}
				}
				s[t] = (int)MAX(-214783647.0,MIN(d * 214783647,214783647.0));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = (double)s[t];
				if(d > volume)
				{
					delta = d - volume;
					d = volume + pow(delta,cut);
				}
				if(side == 1)
				{
					if(d < -volume)
					{
						delta = volume + d;
						d = -volume - pow(delta,cut);
					}
				}
				s[t] = (float)d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				d = s[t];
				if(d > volume)
				{
					delta = d - volume;
					d = volume + pow(delta,cut);
				}
				if(side == 1)
				{
					if(d < -volume)
					{
						delta = volume + d;
						d = -volume - pow(delta,cut);
					}
				}
				s[t] = d;
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::hull(CSample *smp,uint pos,uint len)
{
	uint		t,cn;
	double		d = 0;
	
	module = "hull";

	if(smp == 0) return;

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (d + pow((double)s[t] / 128.0,2) * 0.005) / 1.0008;
				s[t] = (char)MAX(-127.0,MIN(d * 127,127.0));
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (d + pow((double)s[t] / 32768.0,2) * 0.005) / 1.005;
				s[t] = (short)MAX(-32767.0,MIN(d * 32767,32767.0));
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (d + pow((double)s[t] / 214783648.0,2) * 0.005) / 1.005;
				s[t] = (int)MAX(-214783647.0,MIN(d * 214783647,214783647.0));
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (d + pow((double)s[t],2) * 0.005) / 1.005;
				s[t] = (float)d;
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (d + pow(s[t],2) * 0.005) / 1.005;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::noiseGate(CSample *smp,double treshhold,uint pos,uint len)
{
	uint		t,cn;
	double		d = 0;
	
	module = "noisegate";

	if(smp == 0) return;

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (double)s[t] / 128.0;
				if(d < treshhold && d > -treshhold) d = 0;
				s[t] = (char)MAX(-127.0,MIN(d * 127,127.0));
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (double)s[t] / 32768.0;
				if(d < treshhold && d > -treshhold) d = 0;
				s[t] = (short)MAX(-32767.0,MIN(d * 32767,32767.0));
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (double)s[t] / 214783648.0;
				if(d < treshhold && d > -treshhold) d = 0;
				s[t] = (int)MAX(-214783647.0,MIN(d * 214783647,214783647.0));
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = (double)s[t];
				if(d < treshhold && d > -treshhold) d = 0;
				s[t] = (float)d;
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = s[t];
				if(d < treshhold && d > -treshhold) d = 0;
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::distortion(CSample *smp,QArray<double> points,int sym,uint pos,uint len)
{
	uint		t,cn;
	double		d = 0;
	
	module = "distortion";

	if(smp == 0) return;

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = CHAR2D(s[t]);
				d = afxfn(d,points,sym);
				s[t] = D2CHAR(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = SHORT2D(s[t]);
				d = afxfn(d,points,sym);
				s[t] = D2SHORT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = INT2D(s[t]);
				d = afxfn(d,points,sym);
				s[t] = D2INT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = FLOAT2D(s[t]);
				d = afxfn(d,points,sym);
				s[t] = D2FLOAT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = s[t];
				d = afxfn(d,points,sym);
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}


void	CAFX::compress(CSample *smp,double level,uint pos,uint len)
{
	uint		t,cn;
	double		d = 0;
	
	module = "distortion";

	if(smp == 0) return;

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = CHAR2D(s[t]);
				d = afxcompress(d,level);
				s[t] = D2CHAR(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = SHORT2D(s[t]);
				d = afxcompress(d,level);
				s[t] = D2SHORT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = INT2D(s[t]);
				d = afxcompress(d,level);
				s[t] = D2INT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = FLOAT2D(s[t]);
				d = afxcompress(d,level);
				s[t] = D2FLOAT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = s[t];
				d = afxcompress(d,level);
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

void	CAFX::expand(CSample *smp,double level,uint pos,uint len)
{
	uint		t,cn;
	double		d = 0;
	
	module = "distortion";

	if(smp == 0) return;

	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = CHAR2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2CHAR(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = SHORT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2SHORT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = INT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2INT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = FLOAT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2FLOAT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = s[t];
				d = afxexpand(d,level);
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
}

#ifdef undefined
/** Shifts the pitch by shiftfactor. */
void CAFX::shiftpitch(CSample *smp,double shiftfactor,uint pos,uint len)
{
//	CComplex	c[128],r[128];
	fftw_complex	in[2048],filter[2048],out[2048];
	fftw_plan			p1,p2;
	uint					t,cn;
	int						i,n,l = 1024;
	double				d;
	
	module = "shiftpitch";

	if(smp == 0) return;
	
	p1 = fftw_create_plan(l, FFTW_FORWARD, FFTW_ESTIMATE);
	p2 = fftw_create_plan(l, FFTW_BACKWARD, FFTW_ESTIMATE);

//	volume(smp,pos,len);

/*
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = CHAR2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2CHAR(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
*/
	if(smp->isType16())
	{
		short		s[2048];

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			for(t = 0;t + l < len;t += l)
			{
				smp->get(cn,t,l,s);

				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				for(i = 0;i < l;i++)
				{
					in[i].re = SHORT2D(s[i]);
					in[i].im = 0;
					filter[n].re = 0;
					filter[n].im = 0;
				}
				
				fftw_one(p1, in, out);
				
				for(i = 0;i < l;i++)
				{
/*
					d = (double)(i + 1) / shiftfactor - 1;
					n = (int)d;
					filter[i].re = out[n].re;
					filter[i].im = out[n].im;
*/
					d = log(shiftfactor) / log(2);
					n = i + (int)d;
					if(n >= 0 && n < l)
					{
						filter[i].re = out[n].re;
						filter[i].im = out[n].im;
					}
				}
				
				fftw_one(p2, filter, out);
				
				for(i = 0;i < l;i++)
				{
					s[i] = D2SHORT(out[i].re / l);
				}
				smp->set(cn,t,l,s);
			}
		}
		return;
	}
/*	if(smp->isType16())
	{
		short		s[128];

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			for(t = 0;t + 128 < len;t += 128)
			{
				smp->get(cn,t,128,s);

				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				for(i = 0;i < 128;i++)
				{
					c[i] = CComplex(SHORT2D(s[i]));
					r[i] = CComplex(0,0);
				}
				fft(c,128);
				for(i = 0;i < 128;i++)
				{
					d = (double)(i + 1) * shiftfactor - 1;
					n = (int)d;
					if(n >= 0 && n < 128)
					{
						r[n] = r[n] + c[i];
					}
				}
				ifft(r,128);
				for(i = 0;i < 128;i++)
				{
					s[i] = D2SHORT(r[i].real() / 2);
				}
				smp->set(cn,t,128,s);
			}
		}
		return;
	}
*/
/*
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = INT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2INT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = FLOAT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2FLOAT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = s[t];
				d = afxexpand(d,level);
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
*/
	fftw_destroy_plan(p1);
	fftw_destroy_plan(p2);
}
#endif

void	CAFX::fft(CComplex *c,int size)
{
	inversion(c,size);
	transform(c,size,true);
}

void	CAFX::ifft(CComplex *c,int size)
{
	inversion(c,size);
	transform(c,size,false);
	
//	int	n;
	
/*
	for(n = 0;n < size;n++)
	{
		c[n].real() /= (double)size;
		c[n].imaginaer() /= (double)size;
	}
*/
}

void	CAFX::inversion(CComplex *c,int n)	
{
	int				i,j,k;
	CComplex	h;
	
	for(i = j = 1,k = n / 2;i < n;++i,j += k,k = n / 2)
	{
		if(j > i)
		{
			h = c[i - 1];
			c[i - 1] = c[j - 1];
			c[j - 1] = h;
		}
		for(;k < j;j -= k,k = k / 2);
	}
}

void	CAFX::transform(CComplex *c,int n,bool forward)	
{
	int				i,j,k,l,le,m;
	CComplex	h,w,wh;
	
	for(i = n,m = 0;i > 1;++m,i = i / 2);
	for(i = 0;i < m;++i);
	{
		//le = 1 << (i + 1);
		le = 1 << i;
		
		wh = CComplex(1);
		
		if(forward)
		{
			w = CComplex(cos(M_PI / (double)le * 2),-sin(M_PI / (double)le * 2));
		}
		else
		{
			w = CComplex(cos(M_PI / (double)le * 2),sin(M_PI / (double)le * 2));
		}
		for(j = 0;j < le / 2;++j)
		{
			for(k = j;k < n;k += le)
			{
				l = k + le / 2;
				h = c[l] * wh;
				c[l] = c[k] - h;
				c[k] = c[k] + h;
			}
			h = wh * w;
			wh = h;
		}
	}
}

#ifdef undefined
/** Takes a pitch out. */
void CAFX::takepitch(CSample *smp,int pitchnm,uint pos,uint len)
{
//	CComplex	c[128],r[128];
	fftw_complex	in[2048],filter[2048],out[2048];
	fftw_plan			p1,p2;
	uint					t,cn;
	int						i,n,l = 101;
//	double				d;
	
	module = "shiftpitch";

	if(smp == 0) return;
	
	p1 = fftw_create_plan(l, FFTW_FORWARD, FFTW_ESTIMATE);
	p2 = fftw_create_plan(l, FFTW_BACKWARD, FFTW_ESTIMATE);

//	volume(smp,pos,len);

/*
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = CHAR2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2CHAR(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
*/
	if(smp->isType16())
	{
		short		s[2048];

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			for(t = 0;t + l < len;t += l)
			{
				smp->get(cn,t,l,s);

				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				for(i = 0;i < l;i++)
				{
					in[i].re = SHORT2D(s[i]);
					in[i].im = 0;
					filter[n].re = 0;
					filter[n].im = 0;
				}
				
				fftw_one(p1, in, out);
				
				for(i = 0;i < MIN(pitchnm,l);i++)
//				for(i = MAX(pitchnm,0) - 1; i < l;i++)
				{
					filter[i].re = out[i].re;
					filter[i].im = out[i].im;
				}
				
				fftw_one(p1, filter, out);
				
				for(i = 0;i < l;i++)
				{
					s[i] = D2SHORT(out[i].re / l);
				}
				smp->set(cn,t,l,s);
			}
		}
		return;
	}
/*	if(smp->isType16())
	{
		short		s[128];

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			for(t = 0;t + 128 < len;t += 128)
			{
				smp->get(cn,t,128,s);

				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				for(i = 0;i < 128;i++)
				{
					c[i] = CComplex(SHORT2D(s[i]));
					r[i] = CComplex(0,0);
				}
				fft(c,128);
				for(i = 0;i < 128;i++)
				{
					d = (double)(i + 1) * shiftfactor - 1;
					n = (int)d;
					if(n >= 0 && n < 128)
					{
						r[n] = r[n] + c[i];
					}
				}
				ifft(r,128);
				for(i = 0;i < 128;i++)
				{
					s[i] = D2SHORT(r[i].real() / 2);
				}
				smp->set(cn,t,128,s);
			}
		}
		return;
	}
*/
/*
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = INT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2INT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = FLOAT2D(s[t]);
				d = afxexpand(d,level);
				s[t] = D2FLOAT(d);
			}
			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				INDICATE(module,progress);
				d = s[t];
				d = afxexpand(d,level);
				s[t] = d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
		return;
	}
*/
	fftw_destroy_plan(p1);
	fftw_destroy_plan(p2);
}
#endif

/** blurs the sample */
void CAFX::blur(CSample *smp,double size,uint pos, uint len)
{
	uint		t,cn,i;
	double	st,d = 0;
	
	if(smp == 0) return;

	module = "blur";

	for(i = 0;i < size;i++)
	{
		d += 1 / (double)(i + 1);
	}
	
	
	if(smp->isType8())
	{
		char		*s;

		if((s = (char*)malloc(len * sizeof(char))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);
			
			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				st = 0;
				for(i = 0;i < size;i++)
				{
					st += (double)s[t + i] / (double)(i + 1);
				}
				s[t] = (char)MAX(-127,MIN(st / d,127));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
	}
	if(smp->isType16())
	{
		short		*s;

		if((s = (short*)malloc(len * sizeof(short))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				st = 0;
				for(i = 0;i < size;i++)
				{
					st += (double)s[t + i] / (double)(i + 1);
				}
				s[t] = (short)MAX(-32767,MIN(st / d,32767));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
	}
	if(smp->isType32())
	{
		int		*s;

		if((s = (int*)malloc(len * sizeof(int))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				st = 0;
				for(i = 0;i < size;i++)
				{
					st += (double)s[t + i] / (double)(i + 1);
				}
				s[t] = (int)MAX(-214783648,MIN(st / d,214783647));
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
	}
	if(smp->isTypeFL())
	{
		float		*s;

		if((s = (float*)malloc(len * sizeof(float))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				st = 0;
				for(i = 0;i < size;i++)
				{
					st += (double)s[t + i] / (double)(i + 1);
				}
				s[t] = st / d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
	}
	if(smp->isTypeDB())
	{
		double		*s;

		if((s = (double*)malloc(len * sizeof(double))) == 0) return;

		for(cn = 0;cn < (uint)smp->getNChannel();cn++)
		{
			smp->get(cn,pos,len,s);

			for(t = 0;t < len;t++)
			{
				PROGRESS(t,len,cn,smp->getNChannel());
				st = 0;
				for(i = 0;i < size;i++)
				{
					st += (double)s[t + i] / (double)(i + 1);
				}
				s[t] = st / d;
			}

			smp->set(cn,pos,len,s);
		}
		free(s);
	}
}
