/***************************************************************************
                          list.cpp  -  description
                             -------------------
    begin                : Mon Feb 21 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "list.h"
#include "kiconloader.h"
#include "kapp.h"

list::list(QWidget *parent, const char *name) : QWidget(parent,name){
	setCaption("KSoundrecord - Filelist");
	initDialog();
  this->setMaximumWidth(300);
	connect(this->select_all,SIGNAL(clicked()),this,SLOT(slot_select_all()));
	connect(this->select_1,SIGNAL(clicked()),this,SLOT(slot_invert_selection()));
}

list::~list(){
}
/**  */
void list::slot_show_list(QStrList filelist, QList <bool> is_mp3, QList <bool> is_work){
		filelist.first();
	QListViewItem * myChild;
	QListView_1->clear();
	if(filelist.current())
	{
		do
		{
			myChild = new QListViewItem(QListView_1,(QString)filelist.current()+".wav");
			if(*is_mp3.at(filelist.at()))
				myChild->setPixmap(1,ICON("ready.xpm"));
			else
			{
				if(*is_work.at(filelist.at()))
					myChild->setPixmap(1,ICON("work.xpm"));
				else
					myChild->setPixmap(1,ICON("no.xpm"));
    	}	
		} while(filelist.next());
	}
}
/** find the  */
QString list::next_selected(QStrList filelist,bool deselect = false,bool play = false){
	  QListViewItem * myChild = QListView_1->firstChild();
		while( myChild ) {
			if(myChild->isSelected())
				{
				QListView_1->setSelected(myChild,!deselect);
				if(play)
					myChild->setPixmap(1,ICON("list_play.xpm"));
				return (myChild->text(0));
				}
			myChild = myChild->nextSibling();
		}
    delete(myChild);
	 return 0;
}
/**  */
void list::slot_select_all(){
	QListViewItem * myChild = QListView_1->firstChild();
		while( myChild ) {
			QListView_1->setSelected(myChild,true);
			myChild = myChild->nextSibling();
		}
	delete(myChild);
}
/**  */
void list::slot_invert_selection(){
	QListViewItem * myChild = QListView_1->firstChild();
		while( myChild ) {
			if(myChild->isSelected())
				QListView_1->setSelected(myChild,false);
			else	
				QListView_1->setSelected(myChild,true);
			myChild = myChild->nextSibling();
		}
    delete(myChild);
}
/** set all status to no mp3 */
void list::slot_no_mp3(){
	QListViewItem * myChild = QListView_1->firstChild();
		while( myChild ) {
			myChild->setPixmap(1,ICON("no.xpm"));
			myChild = myChild->nextSibling();
		}
	delete(myChild);	
}
/** find all selected in filelist */
QStrList list::all_selected(){
	QStrList qsl;
	QListViewItem * myChild = QListView_1->firstChild();
		while( myChild ) {
			if(myChild->isSelected())
				{
				qsl.append(myChild->text(0));
				}
			myChild = myChild->nextSibling();
		}
    delete(myChild);
	 return qsl;
}
