/***************************************************************************
                          ksoundrecorddoc.cpp  -  description
                             -------------------
    begin                : Don Jan  6 20:17:39 CET 2000
    copyright            : (C) 2000 by Mathias Zander
    email                : mail@mathias-zander.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

// include files for Qt
#include <qdir.h>
#include <qfileinfo.h>
#include <qwidget.h>

// include files for KDE
#include <kapp.h>
#include <kmsgbox.h>

// application specific includes
#include "ksoundrecorddoc.h"
#include "ksoundrecord.h"
#include "ksoundrecordview.h"

QList<KsoundrecordView> *KsoundrecordDoc::pViewList = 0L;

KsoundrecordDoc::KsoundrecordDoc(QWidget *parent, const char *name) : QObject(parent, name)
{
  if(!pViewList)
  {
    pViewList = new QList<KsoundrecordView>();
  }
  cpproc = new KProcess();
  cpopenproc = new KProcess();
  cpmp3proc = new KProcess();
}

KsoundrecordDoc::~KsoundrecordDoc()
{
}

void KsoundrecordDoc::addView(KsoundrecordView *view)
{
  pViewList->append(view);
}

void KsoundrecordDoc::removeView(KsoundrecordView *view)
{
  pViewList->remove(view);
}

void KsoundrecordDoc::setAbsFilePath(const QString &filename)
{
  absFilePath=filename;
}

const QString &KsoundrecordDoc::getAbsFilePath() const
{
  return absFilePath;
}

void KsoundrecordDoc::setTitle(const QString &_t)
{
  title=_t;
}

const QString &KsoundrecordDoc::getTitle() const
{
  return title;
}

void KsoundrecordDoc::slotUpdateAllViews(KsoundrecordView *sender)
{
  KsoundrecordView *w;
  if(pViewList)
  {
    for(w=pViewList->first(); w!=0; w=pViewList->next())
    {
      if(w!=sender)
        w->repaint();
    }
  }

}

bool KsoundrecordDoc::saveModified()
{
  bool completed=true;

  if(modified)
  {
    KsoundrecordApp *win=(KsoundrecordApp *) parent();
    int want_save = KMsgBox::yesNoCancel(win, i18n("Warning"),
                                         i18n("The current file has been modified.\n"
                                              "Do you want to save it?"));
    switch(want_save)
    {
      case 1:
           if (title == i18n("Untitled"))
           {
             win->slotFileSaveAs();
           }
           else
           {
             saveDocument(getAbsFilePath());
       	   };

       	   deleteContents();
           completed=true;
           break;

      case 2:
           setModified(false);
           deleteContents();
           completed=true;
           break;	

      case 3:
           completed=false;
           break;

      default:
           completed=false;
           break;
    }
  }

  return completed;
}

void KsoundrecordDoc::closeDocument()
{
  deleteContents();
}

bool KsoundrecordDoc::newDocument()
{
  /////////////////////////////////////////////////
  // TODO: Add your document initialization code here
  /////////////////////////////////////////////////
  modified=false;
  absFilePath=QDir::homeDirPath();
  title=i18n("Untitled");

  return true;
}

bool KsoundrecordDoc::openDocument(const QString &filename, const char *format /*=0*/)
{
  QFileInfo fileInfo(filename);
  title=fileInfo.fileName();
  absFilePath=fileInfo.absFilePath();	
  /////////////////////////////////////////////////
  // TODO: Add your document opening code here
  /////////////////////////////////////////////////
	
  //opsolete
  /*(*cpopenproc) << "cp" << filename << "/tmp/ksoundrecord.wav";
  cpopenproc->start(); */


  modified=false;
  return true;
}

bool KsoundrecordDoc::saveDocument(const QString &filename, const char *format /*=0*/)
{

  (*cpproc) << "cp" << "/tmp/ksoundrecord.wav" << filename;
  cpproc->start();

  modified=false;
  return true;
}

bool KsoundrecordDoc::savemp3(const QString &filename, const char *format /*=0*/)
{

  (*cpmp3proc) << "cp" << "/tmp/ksoundrecord.mp3" << filename;
  cpmp3proc->start();

  modified=false;
  return true;
}

void KsoundrecordDoc::deleteContents()
{
  /////////////////////////////////////////////////
  // TODO: Add implementation to delete the document contents
  /////////////////////////////////////////////////

}
