/*
  stores decoder in a form {ident,pointer}
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <util/ptrArray.h>


PtrArray::PtrArray(int nSize) {
  int i;
  this->nSize=nSize;
  valueKeyPair=new ValueKeyPair* [nSize];
  for(i=0;i<nSize;i++) {
    valueKeyPair[i]=(ValueKeyPair*) new (ValueKeyPair);
    valueKeyPair[i]->id=-1;   // mark as invalid
  }
  fillPos=0;
}


PtrArray::~PtrArray() {
  int i;
  for(i=0;i<nSize;i++) {
    delete valueKeyPair[i];
  }
  delete valueKeyPair;
}

int PtrArray::maxSize() {
  return nSize;
}


int PtrArray::add(int id,void* ptr) {
  if (fillPos >= nSize) {
    cout << "Couldn't add ptr -> Array overflow"<<endl;
    return false;
  }
  valueKeyPair[fillPos]->ptr=ptr;
  valueKeyPair[fillPos]->id=id;
  fillPos++;
  return true;
}

  
void* PtrArray::find(int id) {
  int i;
  for(i=0;i<fillPos;i++) {
    if (valueKeyPair[i]->id==id) {
      return valueKeyPair[i]->ptr;
    }
  }
  return NULL;
}


int PtrArray::find(void* aPtr) {
  int i;
  for(i=0;i<fillPos;i++) {
    if (valueKeyPair[i]->ptr==aPtr) {
      return valueKeyPair[i]->id;
    }
  }
  return -1;
}


/*
  Note : remove only resizes the Array! The Object of
  the pointer is _not_ freed
*/
void PtrArray::remove(int id) {
  int i;
  int j;
  if (id > 0) {
    for(i=0;i<fillPos;i++) {
      if ((valueKeyPair[i]->id==id) && (id != -1)) {
	for(j=i;j<(fillPos-1);j++) {
	  valueKeyPair[j]->id=valueKeyPair[j+1]->id;
	  valueKeyPair[j]->ptr=valueKeyPair[j+1]->ptr;
	}
	if (fillPos < nSize) {
	  valueKeyPair[fillPos]->id=-1;
	}
	fillPos--;
	break;
      }
    }
  }
}
 

void PtrArray::remove(void* aPtr) {
  int id=find(aPtr);
  remove(id);
}


    
int PtrArray::getFillgrade() {
  return fillPos;
}


void* PtrArray::getPtrAt(int i) {
  if (i >= fillPos) {
    cout << "Access outsize buffer !"<<endl;
    return NULL;
  }
  return valueKeyPair[i]->ptr;
}


int PtrArray::getIdAt(int i) {
  if (i >= fillPos) {
    cout << "Access outsize buffer !"<<endl;
    return 0;
  }
  return valueKeyPair[i]->id;
}


