/*
  property description of a decoder
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */

#include <producer/core/decoderID.h>


DecoderID::DecoderID(int id,int argn,char** args) {
  this->id=id;
  this->argn=argn;
  char** newArgs=NULL;
  if (argn > 0) {
    newArgs=new char*[argn];
    int i;
    for(i=0;i<argn;i++) {
      newArgs[i]=args[i];
    }
  }
  this->args=newArgs;
}


DecoderID::~DecoderID() {
  clear();
}



int DecoderID::getID() {
  return id;
}

void DecoderID::setID(int id) {
  this->id=id;
}


int DecoderID::getArgn() {
  return argn;
}


void DecoderID::addArgs(char* str) {
  int i;
  int newArgn=argn+1;
  char** newArgs=new char*[newArgn];
  for(i=0;i<argn;i++) {
    newArgs[i]=strdup(getArgs(i));
  }
  newArgs[argn]=NULL;
  if (str != NULL) {
    newArgs[argn]=strdup(str);
  }
  clear();
  args=newArgs;
  argn=newArgn;
}


char* DecoderID::getArgs(int i) {
  if ((i < 0) || (i>=argn)) {
    cout << "DecoderID::getArgs access out of range"<<endl;
    return NULL;
  }

  return args[i];
}




void DecoderID::clear() {
  int i;
  if (args != NULL) {
    for(i=0;i<argn;i++) {
      if (args[i] != NULL) {
	delete args[i];
      }
    }
  }
  if (args != NULL) {
    delete args;
  }
  argn=0;
  args=NULL;
}


void DecoderID::print() {
  int i;
  int n=getArgn();
  cout << "************* DecoderID::print entries:"<<n<<endl;
  for(i=0;i<n;i++) {
    cout << "Arg["<<i<<"]="<<getArgs(i)<<endl;
  }
}


int DecoderID::hasArg(char* cmpArg) {
  int i;
  for(i=0;i<argn;i++) {
    if (args[i] != NULL) {
      if (strlen(cmpArg) == strlen(args[i])) {
	if (strncmp(args[i],cmpArg,strlen(cmpArg))==0) {
	  return true;
	}
      }
    }
  }
  return false;
}


int DecoderID::argumentEqualTo(DecoderID* cmp) {
  int i;
  if (cmp==NULL) {
    return false;
  }
  for(i=0;i<argn;i++) {
    if (cmp->hasArg(getArgs(i))==false) {
      return false;
    }
  }
  // left to right equal
  int n=cmp->getArgn();
  for(i=0;i<n;i++) {
    if (hasArg(cmp->getArgs(i))==false) {
      return false;
    }
  }  
  // right to left equal -> success
  return true;
}




void DecoderID::copyTo(DecoderID* dest) {
  if (dest == NULL) {
    cout << "can not copy to NULL in DecoderID::copyTo"<<endl;
    exit(0);
  }
  dest->clear();
  int i;
  for(i=0;i<argn;i++) {
    dest->addArgs(getArgs(i));
  }
}
