/*
  a FFT filter with real/imagery part (can calculate inverse fft!)
  Copyright (C) 1998  Martin Vogt;Philip VanBaren, 2 September 1993

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <filter/fftFilter.h>

FFTFilter::FFTFilter(int fftPoints) {
  int i;
  this->fftPoints = fftPoints;
  data=new float[2*2*fftPoints];  
  window=new float[fftPoints];
  fft= new FFT();

  /* Create the window function (Blackman) */                             
  for(i=0;i<fftPoints;i++) {
    window[i]=0.42-0.5*cos(2*M_PI*i/fftPoints)
              +0.08*cos(4*M_PI*i/fftPoints);   
  }
}


FFTFilter::~FFTFilter() {
  delete data;
  delete fft;
  delete window;
}


int FFTFilter::getPoints() {
  return fftPoints;
}


float* FFTFilter::getPointPtr() {
  return data;
}


/*
  the array is expected to be a PCM stream (real data)
*/
int FFTFilter::fft16(DeviceConfig* input) {
  int i;
  int j;

  AudioStream* audioStream=input->getAudioStream();
  AudioInfo* audioInfo=audioStream->getAudioInfo();

  AudioBuffer* audioBuffer=audioStream->getAudioBuffer();
  MemChunk* memChunk=audioBuffer->getMemChunk();
  
  if (memChunk == NULL) {
    return false;
  }


  short* ptr=(short*)memChunk->getPtr();
  int stereo=audioInfo->getStereo();
  int len=memChunk->getLen()/2;

  if (len < 2) return false;


  j=0;
  int n=min(fftPoints*4,len);
  int mixTmp;

  if (stereo == 1) {
    for (i=0; i < n; i+=2) {
      mixTmp=(ptr[i]+ptr[i+1])/2;
      if (mixTmp < SHRT_MIN) {
	data[j]= (float)SHRT_MIN; 
      } else {
	if (mixTmp > SHRT_MAX) {
	  data[j] = (float)SHRT_MAX; 
	} else {
	  data[j]=(float)mixTmp;
	}
      }
      data[j+1]=0.0;
      j+=2;
    }
  }

  /*

  if (stereo == 1) {
    for (i = 0, j = 0; i < n; i++, j+=2) {
      data[j] = (float)(ptr[j]);
      data[j+1]=0.0;
    }
    
  }
  */
  fft->rfft(data,fftPoints*4,1);
  return true;
}



void FFTFilter::inverseFFT16(float* data) {
  fft->fft(data,fftPoints*2,-1);
}



int FFTFilter::min(int x1,int x2) { 
  if (x1 < x2) {
    return x1;
  }
  return x2;
}

