
#include "qwAudio-p.h"

#ifdef _HAVE_NAS

QwAuServer::QwAuServer() {
  nas = NULL;
  ringBuffer=new RingBuffer(RINGBUFFERSIZE,LOW_WATER);
  gmemWrite=new MemChunk(0);
  gmemRead=new MemChunk(0);
  pthread_mutex_init(&changeMut,NULL);
  sn=NULL;
}


QwAuServer::~QwAuServer() {
  close();
  delete gmemWrite;
  delete gmemRead;
}


void QwAuServer::lockServer() {
  pthread_mutex_lock(&changeMut);
}


void QwAuServer::unlockServer() {
  pthread_mutex_unlock(&changeMut);
}



AuServer* QwAuServer::getAuServer() {
  return nas;
}


int QwAuServer::isOpen() {
  return (nas!=NULL);
}


void QwAuServer::timerEvent(QTimerEvent *) {
  dataReceived();
  killTimers();
}


int QwAuServer::writeToRingBuffer(char* buf,int len) {

  // should be in rinbuffer !!  
  // ringBuffer->write(buf,len) :
  while(len > 0) {
    ringBuffer->waitForSpace(len);
    ringBuffer->getWriteArea(gmemWrite,len);
    memcpy(gmemWrite->getPtr(),buf,gmemWrite->getLen());
    len=len-gmemWrite->getLen();
    buf=buf+gmemWrite->getLen();
    ringBuffer->forwardWritePtr(gmemWrite->getLen());
  }
 
  return len;
}


void QwAuServer::dataReceived() {
  lockServer();
  AuHandleEvents(nas);
  unlockServer();
}


int QwAuServer::open(char* display) {
  nas = AuOpenServer(display, 0, NULL, 0, NULL, NULL);
  if (nas) {
    sn=new QSocketNotifier(AuServerConnectionNumber(nas),
			   QSocketNotifier::Read);
    QObject::connect(sn, SIGNAL(activated(int)),this, SLOT(dataReceived()));
  } 
  return isOpen();
}


void QwAuServer::close() {
  if (isOpen()) {
    delete sn;
    AuCloseServer(nas);
    sn=NULL;
    nas=NULL;
  }
}


int QwAuServer::sendDataToNASServer(AuFlowID auFlowID,
				     int element,int bytes) {
  ringBuffer->getReadArea(gmemRead,bytes);
  AuStatus status=AuSuccess;
  AuWriteElement(nas,auFlowID,0,gmemRead->getLen(),
		 gmemRead->getPtr(),AuFalse,&status);
  if (status != 0) {
    return 0;
  }
  // upload successfully
  ringBuffer->forwardReadPtr(gmemRead->getLen());
  ringBuffer->forwardLockPtr(gmemRead->getLen());
  return gmemRead->getLen();
}


void QwAuServer::clear() {
  ringBuffer->emptyBuffer();
}


int QwAuServer::getFillgrade(){
  return ringBuffer->getFillgrade();
}

#endif

