/*
  stores author/name/length etc. of song
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __MUSICINFO_H
#define __MUSICINFO_H


#include <yafcore/buffer.h>
#include <deviceConfig/info/info.h>


class MusicInfo : public Info {

 public:
  MusicInfo();
  ~MusicInfo();

  void setName(char* newName);
  char* getName();

  void setFileName(char* filename);
  char* getFileName();

  void setLen(int sec);
  int getLen();

  void setJumps(int jumps);
  int getJumps();
 

  void copyTo(MusicInfo* dest);
  void print();

 private:

  Buffer* filename;
  Buffer* name;
  int len;
  // jumps are the number of jump points in the Music (mostly len==jumps)
  int jumps;
};
#endif
