/*
  buffers audiodata
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#include <deviceConfig/info/audioBuffer.h>


AudioBuffer::AudioBuffer() { 
  memChunk=NULL;
  nReadBytes=0;
  lBufferFilled=false;
  percent=0.0;
  prefFillGrade=_AUDIOBUFFER_PREFERRED_FILLGRADE_DEFAULT;
}


AudioBuffer::~AudioBuffer() {
} 



MemChunk* AudioBuffer::getMemChunk() { 
  return memChunk; 
}

int AudioBuffer::getPreferredFillGrade() {
  return prefFillGrade;
}


void AudioBuffer::setPreferredFillGrade(int prefGrade) {
  prefFillGrade=prefGrade;
}


void AudioBuffer::setMemChunk(MemChunk* aChunk) { 
  memChunk=aChunk;
}


void AudioBuffer::copyTo(AudioBuffer* aBuffer) {
  aBuffer->setMemChunk(getMemChunk());
  aBuffer->setPreferredFillGrade(getPreferredFillGrade());
  aBuffer->setMainBufferFillgrade(getMainBufferFillgrade());
}


void AudioBuffer::print() {
  cout << "AudioBuffer-begin-"<<endl;
  cout << "memchunk:"<<memChunk<<endl;
  if (memChunk != NULL) {
    cout << "memChunk-len:"<<memChunk->getLen()<<endl;
  } 

    
  cout << "prefSize:"<<getPreferredFillGrade()<<endl;
  cout << "readBytes:"<<getReadBytes()<<endl;
  cout << "fillgrade:"<<getMainBufferFillgrade()<<endl;
  
  cout << "AudioBuffer-end-"<<endl;
}


int AudioBuffer::getReadBytes() {
  return nReadBytes;
}


void AudioBuffer::setReadBytes(int bytes) {
  this->nReadBytes=bytes;
}


int AudioBuffer::getBufferFilled() {
  return lBufferFilled;
}


void AudioBuffer::setBufferFilled(int value) {
  lBufferFilled=value;
}
 

float AudioBuffer::getMainBufferFillgrade() {
  return percent;
}


void AudioBuffer::setMainBufferFillgrade(float percent) {
  if (this->percent!=percent) {
    setChange(true);
    this->percent=percent;
  }
}
 
