/*
  describes decoders in an abstract way
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __DECODER_H
#define __DECODER_H

#include <iostream.h>
#include <amplifier/extension.h>

#define _NO_DECODER 0

#define _MP3_DECODER 1


#define _IMAGE_VIEWER 5
#define _WAV_DECODER 6
#define _MPEG_VIDEO_DECODER 7


/**
   This class defines an abstract interface for decoders.
   It should allow a mapping from an extension ID to a
   "start string".
   <p>
   Example:
   <p>
   The user want to play an mp3 file. The extension class
   gives us the type of decoder we need. (EXTENSION_MP3) 
   Then we scan all known decoders if we have such a decoder.
   If we found an mp3 decoder, we can create a start description
   for it and can start the decoder.
   <p>
   This class can as well handle configuration settings.
   But only in a GUI independent way.
*/
   

class Decoder {


 public:
  Decoder();
  virtual ~Decoder();

  virtual char* getName();
  virtual int getDecoderID();

  // this should be improved to a more general config interface
  virtual void setConfigID(int id);
  virtual int getConfigID();
  virtual char** getExecutable();

 protected:
  int id;

};


#endif
