/*
  fifo queue for packets
  Copyright (C) 2000  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "packetArray.h"




PacketArray::PacketArray(int size) {
  writePos=0;
  readPos=0;
  fillgrade=0;
  this->size=size;
  if (size < 1) {
    cout << "PacketArray size must be >= 1";
    exit(0);
  }
  int i;
  packetDescriptionArray=new PacketDescription*[size];

  for(i=0;i<size;i++) {
    packetDescriptionArray[i]=new PacketDescription();
  }

}


PacketArray::~PacketArray() {
  int i;

  for(i=0;i<size;i++) {
    delete packetDescriptionArray[i];
  }
  delete packetDescriptionArray;
}

PacketDescription* PacketArray::getPacket(int number) {
  int realPos=readPos+number-1;
  if (number > fillgrade) {
    cout << "getPacket access [number] out of bound"<<endl;
    exit(0);
  }
  if (realPos >= size) {
    realPos=realPos-size;
  }
  return packetDescriptionArray[realPos];
}


void PacketArray::insert(PacketDescription* packetDescription) {
  if (writePos == readPos) {
    if (fillgrade == size) {
      cout << "PacketArray cannot insert packet, Array full!"<<endl;
      return;
    }
  }
  packetDescription->copyTo(packetDescriptionArray[writePos]);
  writePos++;
  if (writePos==size) {
    writePos=0;
  }
  fillgrade++;
}


void PacketArray::forward() {
  PacketDescription* packet=getPacket(1);
  if (packet->getData() != NULL) {
    delete packet->getData();
    packet->setData(NULL);
  }

  fillgrade--;
  readPos++;
  if (readPos==size) {
    readPos=0;
  }

  
}


void PacketArray::clear() {
  while (getFillgrade() > 0) {
    forward();
  }
}

int PacketArray::getFillgrade() {
  return fillgrade;
}
