/*
  reads/parse slice infos
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __SLICE_H
#define __SLICE_H

#include <iostream.h>
#include "video.h"
#include "mpegPlayBitWindow.h"
#include "util.h"
#include "jrevdct.h"


/* Size increment of extension data buffers. */

#define EXT_BUF_SIZE 1024

class Slice {

  VidStream* vid_stream;


 public:
  Slice(VidStream* vid_stream);
  ~Slice();
  int parseSlice();
  unsigned int getVertPos();
  inline unsigned int getQuantScale() {return quant_scale;}
  void setQuantScale(unsigned int quant_scale);
  

 private:

  /* Slice structure. */

  unsigned int vert_pos;                 /* Vertical position of slice. */
  unsigned int quant_scale;              /* Quantization scale.         */
  char *extra_info;                      /* Extra bit slice info.       */

};


#endif
