/*
  nice try of an X11 output plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "pictureArray.h"



PictureArray::PictureArray(int width, int height, int bpp) {
  int i;
  for (i=0;i<_PICTURE_ARRAY_SIZE;i++) {
    pictureArray[i]=NULL;
  }

  for (i=0;i<_PICTURE_ARRAY_SIZE;i++) {
    if (pictureArray[i] == NULL) {
      pictureArray[i]=new Picture(width,height,bpp);
    }
  }  

  /* Find a pict image structure in ring buffer not currently locked. */
  /* Set current pict image structure to the one just found in ring. */
  
  current=getEmptyPicImage();
  past=getEmptyPicImage();
  future=getEmptyPicImage();

  picPerSec=0.0;

}


PictureArray::~PictureArray() {
  int i;
  for (i=0;i<_PICTURE_ARRAY_SIZE;i++) {
    if (pictureArray[i] != NULL) {
      delete pictureArray[i];
      pictureArray[i]=NULL;
    }
  } 
}



Picture* PictureArray::getEmptyPicImage() {
  int i = 0;
  int lock=pictureArray[i]->getLock();
  while (lock) {
    if (++i >= _PICTURE_ARRAY_SIZE) {
      cout << "Fatal error. Ring buffer full."<<endl;
      exit(1);
    }
    lock=pictureArray[i]->getLock();
  }
  pictureArray[i]->setLock(true);
  return pictureArray[i];
}


void PictureArray::setPicturePerSecond(float val) {
  picPerSec=val;
}


float PictureArray::getPicturePerSecond() {
  return picPerSec;
}




void PictureArray::forward() {
  /* Update past and future references if needed. */

  Picture* tmp=past;

  past = future;
  future = current;
  current = tmp;
    

}
