/*
  mpeg player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "mpegPlugin.h"


MpegPlugin::MpegPlugin() {
  init(NULL);
}

MpegPlugin::MpegPlugin(SequenceParse* sequenceParse) {
  init(sequenceParse);
}

MpegPlugin::~MpegPlugin() {
}


void MpegPlugin::init(SequenceParse* sequenceParse) {
  mpegLength=NULL;
  lCalcLength=false;
  lDoResync=true;
  this->sequenceParse=sequenceParse;
  currentSequence=NULL;
}


void MpegPlugin::decoder_loop() {
  int lInit=false;
  int lfirst=true;
  
  VidStream* video=NULL;
  cout << "MpegPlugin::decoder_loop()"<<endl;
  if (input == NULL) {
    cout << "MpegPlugin::decoder_loop input is NULL"<<endl;
    exit(0);
  }
  if (sequenceParse == NULL) {
    if (output == NULL) {
      cout << "MpegPlugin::decoder_loop output is NULL"<<endl;
      exit(0);
    }
  }
  if(sequenceParse != NULL) {
    currentSequence=sequenceParse;
  } else {
    if (currentSequence != NULL) {
      delete currentSequence;
    }
    currentSequence=new SequenceParse(output);
  }

  MpegPlayBitWindow* bitwindow=new MpegPlayBitWindow(input);

  output->setOutputInit(false);
  // now calulcate length
  if (lCalcLength) {
    mpegLength=new MpegLength(input);
    cout << "startCalc"<<endl;
    mpegLength->startCalc();
  }
  pluginInfo->setLength(getSongLength());
  cout << "MpegPlugin::decoder_loop() enter loop"<<endl;
  lDoResync=true;

  // init loop
  while(lDecoderLoop && lCreatorLoop) {

    // our parent has us send nothing, we do init ourself
    if (sequenceParse == NULL) {
      cout << "mpegPlugin firstSync"<<endl;
      if(bitwindow->firstSync()==false) {
	lDecoderLoop=false;
	leof=true;
	continue;
      }
      int lfound=DeMux::skip_to_start_code(bitwindow,SEQ_START_CODE);
      if (lfound==false) {
	continue;
      }
      // found SEQ_START_CODE
      SequenceParse::parseSeq(bitwindow,currentSequence->getSequence());
      cout << "************* parseSeq"<<endl;
      lDoResync=false;
     
    }
    break;
  }


  cout << "NewVidStream -s"<<endl;
  video=NewVidStream(bitwindow,currentSequence);
  cout << "NewVidStream -e"<<endl;

  // decode loop
  while(lDecoderLoop && lCreatorLoop) {
    if (pthread_mutex_trylock(&decoderChangeMut) == EBUSY) {
      pthread_cond_wait(&decoderCond,&decoderMut);
      continue;
    }
    pthread_mutex_unlock(&decoderChangeMut);
    if (lDecode) {
      if (lDoResync) {
	cout << "resyncToI_Frame -s"<<endl;
	resyncToI_Frame(video);
	if (DeMux::next_start_code(video->bitwindow)==false) {

	} else {
	  unsigned int data=video->bitwindow->showBits(32);
	  printf("data:%8x\n",data);
	  if ( (data == SEQ_START_CODE) ||
	       (data == GOP_START_CODE) ||
	       (data == PICTURE_START_CODE) ||
               (data == SLICE_MIN_START_CODE) ) {
	    lDoResync=false;
	  } else {
	    video->bitwindow->flushBits(32);
	  }
	}
      } else {
	if (mpegVidRsrc(video, 0)==false) {
	  lDoResync=true;
	  
	}
      }
      if (input->eof()){
	lDecoderLoop=false;
	leof=true;
	continue;
      }
    } else {
      pthread_cond_wait(&decoderCond,&decoderMut);
   }
  }
  leof=true;
  output->flushWindow();
  DestroyVidStream(video);
  delete video;
  video=NULL;
  delete mpegLength;

  delete bitwindow;
  mpegLength=NULL;
  pthread_mutex_unlock(&decoderMut);
}


int MpegPlugin::seek(int second) {
  cout << "MpegPlugin seek"<<endl;
  lDoResync=true;
  return false;
}



// here we can config our decoder with special flags
void MpegPlugin::config(char* key, char* value) {
  if (strcmp(key,"-c")==0) {
    lCalcLength=false;
  }
  if (strcmp(key,"-r")==0) {
    lDoResync=true;
  }  
  PlayerPlugin::config(key,value);
}



int MpegPlugin::getSongLength() {
  if (mpegLength == NULL) {
    return 0;
  }
  int back=mpegLength->getLength();
  return back;
}


SequenceParse* MpegPlugin::getSequenceInfo() {
  return currentSequence;
}

void MpegPlugin::setResync(int lResync) {
  lDoResync=lResync;
}


int MpegPlugin::getResync() {
  return lDoResync;
}
