/*
  mpg I video/audio player plugin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#ifndef __MPEGLENGTH_H
#define __MPEGLENGTH_H

#include "video.h"
#include "mpegPlayBitWindow.h"
#include "timeCode.h"




/**
   This class calculates the length (in seconds) of an mpeg stream.
   I do not know how to make it right, my approach
   seeks at the beginning of the stream for the timecode in
   the picture gop then jumps near the end and does the same.
   then it substracts the values.
*/

class MpegLength {


  InputStream* input;
  TimeCode* timeCodeStart;
  TimeCode* timeCodeEnd;
  TimeCode* timeCodeLength;

 public:
  MpegLength(InputStream* input);
  ~MpegLength();

  long getLength();
  long getSeekPos(int seconds);
  void startCalc();

 private:
  void readTimeCode(TimeCode* timeCode,MpegPlayBitWindow* bitwindow);
  int seekToStart();
  int seekToEnd();
  int seekValue(unsigned int code,MpegPlayBitWindow* bitwindow,long& endPos);
  int parseToGOP(TimeCode* timeCode,MpegPlayBitWindow* bitwindow);

};
#endif

