/*
  generic input class
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __INPUTSTREAM_H
#define __INPUTSTREAM_H



#include "timeStampArray.h"
#include <iostream.h>
#include <string.h>
#include "../playerPlugin/pluginInfo.h"


class InputStream {



 public:
  InputStream();
  InputStream(char* name);

  virtual ~InputStream();

  virtual int open(char* dest);
  virtual void close();
  virtual int isOpen();

  virtual int eof();
  virtual int read(char* ptr,int size);
  virtual int seek(long bytePos);

  virtual long getByteLength();
  virtual long getBytePosition();

  virtual void insertTimeStamp(TimeStamp* src,long key,int len);
  virtual TimeStamp* getTimeStamp(long key);
  virtual int bytesUntilNext(long key);
  virtual void print();
  char* getUrl();

  // return position in string where path starts 
  // or 0 on error
  static int getPath(char* url,char* protocol);

 protected:
  DynBuffer* urlBuffer;


  TimeStampArray* timeStampArray;
  void setUrl(char* url);

 private:
  void init(char* name);

  
};
#endif
