/*
  configuration for option of the winampSkin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __WASKINCONFIGOPTION_H
#define __WASKINCONFIGOPTION_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>
#include <qcombobox.h> 
#include <waDropSkinWidget.h>
#include <song.h>

#define _WASKINCONFIGOPTION_USE_LAST      1
#define _WASKINCONFIGOPTION_IGNORE        2


class WaSkinConfigOption : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

 public:
   WaSkinConfigOption(const char* configGroup,
		      QWidget * parent=0, const char * name=0 );
   ~WaSkinConfigOption();

   const char* getGroupName();
   void load();
   void save();
   void apply();

 public slots:
   void setErrorMode(int errorMode);
  
 signals:
   void applyEvent();

 private:
   int errorMode;


};
#endif
