/*
  allows dropping of skin directories and shows main.bmp
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <waDropSkinWidget.h>



WaDropSkinWidget::WaDropSkinWidget(QWidget * parent=0, const char * name=0 )
  : QWidget( parent, name) {
  filename=new Buffer(10);
  
}


WaDropSkinWidget::~WaDropSkinWidget() {
  delete filename;
}



QSize WaDropSkinWidget::sizeHint() {
  return QSize(275,116);
}


void WaDropSkinWidget::setMainFile(char* dir) {
  if (strcmp(dir,filename->getData())==0) {
    return;
  }
  filename->clear();
  filename->append(dir); 
  
  QString file(filename->getData());
  int lFound=WaSkinOperation::getPixmap(file,"main.bmp",&mainpix);

  if (lFound == false) {
    return;
  }  
  repaint(false);
}


void WaDropSkinWidget::paintEvent ( QPaintEvent * paintEvent ) {
  QPainter paint;
  paint.begin( this );
  paint.drawPixmap ( 0, 0, mainpix);
  paint.end();  
}

