/*
  configuration for kmpgSkin
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef __KMPGSKINCONFIG_H
#define __KMPGSKINCONFIG_H

#include <prefConfig.h>


#include <kconfig.h>

#include <qlabel.h>
#include <qpushbt.h>
#include <qbttngrp.h>
#include <qradiobt.h>
#include <qchkbox.h>
#include <qlined.h>
#include <qtabdlg.h>
#include <qlayout.h>

#include <song.h>


class KmpgSkinConfig : public PrefConfig {
 Q_OBJECT
   
  KConfig* config;
  const char* configGroup;

  bool doWarn_cfg;
  bool playNext_cfg;

 public:
   KmpgSkinConfig(const char* configGroup,
		    QWidget * parent=0, const char * name=0 );
   ~KmpgSkinConfig();

   const char* getGroupName();
   void load();
   void save();
   void apply();
   
 signals:
   void applyEvent();

 public slots:
 
   QColor* getBackgroundColor();
   void setBackgroundColor();
   QColor* getForegroundColor();
   void setForegroundColor();

 private:

};
#endif
