/*
  a nicer widget for the decoder control
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __CONTROLWIDGET_H
#define __CONTROLWIDGET_H



#include <qpushbt.h>
#include <qpainter.h>
#include <qlayout.h> 


#include <kiconloader.h>
#include <kapp.h>
#include <iostream.h>


#define ADD_BUTTON( btn, lay, target, icon ) \
   btn = new QPushButton( this ); \
   btn->setPixmap( loader->loadIcon(icon) ); \
   btn->setMinimumSize( btn->sizeHint() );  \
   btn->setMaximumSize( btn->sizeHint() ); \
   lay->addWidget(btn); \
   connect( btn, SIGNAL(clicked()), this, target )




class ControlWidget : public QWidget {
 Q_OBJECT

  QBoxLayout * layout;
  QPushButton* pauseButton;
  QPushButton* playButton;
  QPushButton* stopButton;
  QPushButton* prevButton;
  QPushButton* nextButton;
  QPushButton* ejectButton;
  
 public:
  ControlWidget( QWidget *parent=0, const char *name=0 );
  ~ControlWidget();
  QSize sizeHint() const;
  void buildGui();

 signals:
   void playCurrentEvent();
   void playNextEvent();
   void playPrevEvent();
   void playStopEvent();
   void playPauseEvent();
   void ejectEvent();
  
};


#endif

