/*
  Configuration for the TimerDevice
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <timerDeviceConfig.h>


TimerDeviceConfig::TimerDeviceConfig(char* configGroup,
				   QWidget * parent=0, const char * name=0 ) 
                 : PrefConfig(parent,name) {

  config = kapp->getConfig();
  this->configGroup=configGroup;
  hexFormat=new Buffer(10);
  load();


  a_bg = new QButtonGroup(i18n("Arithmetik"),this);
  QVBoxLayout *a_vbox = new QVBoxLayout(a_bg, 5);
  a_vbox->addSpacing( a_bg->fontMetrics().height() );
  QRadioButton* a_rb1 = new QRadioButton( i18n("Dec") ,a_bg );
  a_bg->insert(a_rb1,_TIMEMODE_ARITH_DEC);
  a_rb1->setMinimumSize( a_rb1->sizeHint() );

  QRadioButton* a_rb2 = new QRadioButton( i18n("Hex") ,a_bg );
  a_rb2->setMinimumSize( a_rb2->sizeHint() );
  a_bg->insert(a_rb2,_TIMEMODE_ARITH_HEX);

  a_vbox->addWidget(a_rb1);
  a_vbox->addWidget(a_rb2);

  a_bg->setButton(arith_cfg);
  a_bg->setGeometry(20,20,100,100);

  // Now the mode box

  m_bg = new QButtonGroup(i18n("Mode"),this);
  QVBoxLayout *m_vbox = new QVBoxLayout(m_bg, 5);
  m_vbox->addSpacing( m_bg->fontMetrics().height() );
  QRadioButton* m_rb1 = new QRadioButton(i18n("played"),m_bg );
  m_bg->insert(m_rb1,_TIMEMODE_PLAYED);
  m_rb1->setMinimumSize( m_rb1->sizeHint() );

  QRadioButton* m_rb2 = new QRadioButton(i18n("remain"),m_bg );
  m_rb2->setMinimumSize( m_rb2->sizeHint() );
  m_bg->insert(m_rb2,_TIMEMODE_REMAIN);

  m_vbox->addWidget(m_rb1);
  m_vbox->addWidget(m_rb2);

  m_bg->setButton(mode_cfg);
  m_bg->setGeometry(140,20,100,100);


  connect(a_bg,SIGNAL(pressed (int)),SLOT(setArith(int)));
  connect(m_bg,SIGNAL(pressed (int)),SLOT(setTimeMode(int)));

}


TimerDeviceConfig::~TimerDeviceConfig() {
  delete hexFormat;
}


void TimerDeviceConfig::setArith(int arith) {
  arith_cfg=arith;
}

   
void TimerDeviceConfig::setTimeMode(int mode) {
  mode_cfg=mode;
}


int TimerDeviceConfig::getTimeMode() {
  return mode_cfg;
}


const char* TimerDeviceConfig::getGroupName() {
  return i18n("Timer");
}


void TimerDeviceConfig::load() {
  config->setGroup(configGroup);
  arith_cfg=config->readNumEntry( "arith", _TIMEMODE_ARITH_DEC);
  mode_cfg=config->readNumEntry("mode",_TIMEMODE_PLAYED);
}


void TimerDeviceConfig::save() {
  config->setGroup(configGroup);
  config->writeEntry( "arith",arith_cfg);
  config->writeEntry("mode",mode_cfg);
}


void TimerDeviceConfig::apply() {
  save();
}


void TimerDeviceConfig::translate(TimeInfo* timeInfo,
				  MusicInfo* musicInfo,Buffer* dest) {
  int time=timeInfo->getTotalSec();
  int len=musicInfo->getLen();

  if (arith_cfg==_TIMEMODE_ARITH_DEC) {
    getFormatDec(time,len,dest);
  }
  if (arith_cfg==_TIMEMODE_ARITH_HEX) {
    getFormatHex(time,len,dest);
  }

}



void TimerDeviceConfig::getFormatDec(int played,int len,Buffer* dest) {
  int size=dest->getSize();
  char* format1="-%d:%d";
  char* format2="-%d:0%d";
  char* format3="%d:%d";
  char* format4="%d:0%d";
  char* format="";
  int time=played;
  int min;
  int sec;
  
  if (mode_cfg == _TIMEMODE_REMAIN) {
    time=len-played;
  }
 
  min=time/60;
  sec=time%60;

  if (sec < 10) {
    if ((mode_cfg == _TIMEMODE_REMAIN) && (time != 0)){
      format=format2;
    } else {
      format=format4;
    }
  } else {
    if (mode_cfg == _TIMEMODE_REMAIN) {
      format=format1;
    } else {
      format=format3;
    }
  } 
  dest->clear();
  snprintf(dest->getData(),size,format,min,sec);
}


void TimerDeviceConfig::getFormatHex(int played,int len,Buffer* dest) {
  int size=dest->getSize();
  char* format1="-%0X";
  char* format2="%0X";
  char* format="";
  int time=played;

  
  if (mode_cfg == _TIMEMODE_REMAIN) {
    time=len-played;
  }
 
  if ((mode_cfg == _TIMEMODE_REMAIN) && (time != 0)){
    format=format1;
  } else {
    format=format2;
  }

  dest->clear();
  snprintf(dest->getData(),size,format,time);

}



