/*
  gui part for the volume device (very simple)
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiVolumeDevice.h>




GuiVolumeDevice::GuiVolumeDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  volumeDevice=NULL;
  connect(this,SIGNAL(valueChanged(int)),this,SLOT(setVolume(int)));
}


GuiVolumeDevice::~GuiVolumeDevice() {
}



void GuiVolumeDevice::attachTo(VolumeDevice* volumeDevice) {
  this->volumeDevice=volumeDevice;
  GuiDevice::attachTo(volumeDevice);
  emit(valueChanged(getVolume()));
}


void GuiVolumeDevice::detach() {
  volumeDevice=NULL;
  GuiDevice::detach();
}



int GuiVolumeDevice::getVolume() {
  if (volumeDevice != NULL) {
    int back=volumeDevice->getVolume();
    return back;
  }
  return 0;
}




void GuiVolumeDevice::buildGui() {
  sb = new QSlider(0,100,1,100,QSlider::Horizontal,this,"Slider");
  sb->setTickInterval( 10 );
  sb->setValue(getVolume());
  sb->setGeometry(0,0,80,28);
  connect(this,SIGNAL(valueChanged(int)),sb,SLOT(setValue(int)));
  connect(sb,SIGNAL(valueChanged(int)),this,SIGNAL(valueChanged(int)));
  
}



void GuiVolumeDevice::setVolume(int percent) {
  if (volumeDevice == NULL) {
    cout << "error volumeDevice not attached"<<endl;
    return;
  }
  volumeDevice->setVolume(percent);
}


QSize GuiVolumeDevice::sizeHint () {
  return QSize(80,28);
}

 



