/*
  gui part shows the audioBuffer fillgrade
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#include <guiBufferInfoDevice.h>




GuiBufferInfoDevice::GuiBufferInfoDevice(QWidget *parent=0, 
			       const char *name=0):GuiDevice( parent, name ) {
  audioStreamInfoDevice=NULL;
  currentFillgrade=0;
}


GuiBufferInfoDevice::~GuiBufferInfoDevice() {
}



void GuiBufferInfoDevice::attachTo(AudioStreamInfoDevice* audioStreamInfoDevice) {
  this->audioStreamInfoDevice=audioStreamInfoDevice;
  GuiDevice::attachTo(audioStreamInfoDevice);
}


void GuiBufferInfoDevice::detach() {
  audioStreamInfoDevice=NULL;
  GuiDevice::detach();
}




void GuiBufferInfoDevice::processEvent(char eventId) {
  if (eventId != _AUDIOSTREAMINFO_BUFFERFILL_CHANGE) {
    return;
  }

  if (getFillgrade() <= 97) {
    update();
  } else {
    if (currentFillgrade != 100) {
      update();
    }
  }
 
}


int GuiBufferInfoDevice::getFillgrade() {
  if (audioStreamInfoDevice != NULL) {
    AudioBuffer* audioBuffer=audioStreamInfoDevice->getAudioBuffer();
    int percent=(int)(100.0*audioBuffer->getMainBufferFillgrade());
    return percent;
  }
  return 0;
}


QSize GuiBufferInfoDevice::sizeHint() const {
  return QSize(10,15);
}


void GuiBufferInfoDevice::paintEvent ( QPaintEvent * paintEvent ) {
  QPainter paint;
  char zahl[10];

  currentFillgrade=getFillgrade();
  // avoid flicker between fillgrade 100 and 99
  // this give 3% more speed gain for my Xserver (P166)
  if (currentFillgrade >= 97) {
    currentFillgrade=100;
  }

  snprintf((char*)&zahl,10,"%d",currentFillgrade);

  paint.begin( this );
  paint.drawText(0,10,zahl);
  paint.end();  

}
