/*
  device stores the current video Info
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __VIDEODEVICE_H
#define __VIDEODEVICE_H

#include <devices/outputDevice.h>

/**
   The video device lets access you the video data in the stream.
   A gui can use this device to display the images on the screen.

   Note:
   Its a bit hard to make this thread safe. There are the following 
   problems:
   * It must be made sure that the data which the gui displays keeps
     valid until it is really displayed!

   For this the gui must lock the videoStream.
   The gui must do the following with this device:

   requestLock();
   getCurrentImage();
   // display image 
   // AND AFTER SUCCESSFULLY DISPLAYED:
   releaseLock();


*/


class VideoDevice :public OutputDevice {

  VideoInfo* current;
 public:
  VideoDevice();
  ~VideoDevice();

  char* getNodeName();

  int requestLock();
  void releaseLock();
  QPixmap* getCurrentPixmap();

  void writeIn(NodeDevice* source,DeviceConfig* config);

};

#endif
  
