#include <amplifier/amplifier.h>
#include <devices/genericPlayer.h>
#include <devices/audioDevice.h>
#include <deviceConfig/mem/garbageCollector.h>

#include "channelWidget.h"


#include <unistd.h>

#include <kapp.h>


/**
   This example show how to implement a new device.
   The device selects the left/right channel out of 
   the audiostream.
   (time consuming)

   Make sure youe have edited the file

   ../SONGS.DEF


*/



#include "../SONGS.DEF"




int main(int nargs,char** args) {
  KApplication a( nargs, args);

  GarbageCollector::init();
  GenericPlayer* player;
  ChannelDevice* channelDevice=new ChannelDevice();
  AudioDevice* audioDevice=new AudioDevice("/dev/dsp");

  audioDevice->open();
  player=Amplifier::createPlayer(_MP3_DECODER);

  // attention of the side effect !!!
  // this gives the order of execution
  player->addListener(channelDevice);
  player->addListener(audioDevice);



  ChannelWidget* channelWidget=new ChannelWidget();
  channelWidget->attachTo(channelDevice);
  channelWidget->show();

  cout << "open file:"<<song[2]<<endl;
  player->open(song[2]);
  a.exec();
  delete player;
  return 0;
}



  
