/*
  A simple radiobutton widget in QT
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#include "channelWidget.h"



ChannelWidget::ChannelWidget( QWidget *parent=0, const char *name=0 ) {

  channelDevice=new ChannelDevice();

  QButtonGroup* bgroup = new QButtonGroup(this);
  QRadioButton *rb1 = new QRadioButton( "Left" ,bgroup);
  QRadioButton *rb2 = new QRadioButton( "Right" ,bgroup);

  
  bgroup->insert(rb1,_CHANNEL_LEFT);
  bgroup->insert(rb2,_CHANNEL_RIGHT);
  

  bgroup->resize(60,60);
  rb1->setGeometry(5,5,40,20);
  rb2->setGeometry(5,25,40,20);
  connect(bgroup,SIGNAL( clicked(int) ) ,this,SLOT( clicked(int) ));
  
}


ChannelWidget::~ChannelWidget() {
}


void ChannelWidget::attachTo(ChannelDevice* channelDevice) {
  if (channelDevice != NULL) {
    cout << "channelDevice != NULL. call ignored"<<endl;
  }
  this->channelDevice=channelDevice;
}


void ChannelWidget::detach() {
  channelDevice=NULL;
}

 

void ChannelWidget::clicked(int channel) {
  cout << "clicked: "<<channel<<endl;
  if (channelDevice != NULL) {
    channelDevice->setChannel(channel);
  }
}



