/*
  selects the right/left channel in a stream
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __CHANNELDEVICE_H
#define __CHANNELDEVICE_H

#include <devices/outputDevice.h>

#define _CHANNEL_NONE   0
#define _CHANNEL_LEFT   1
#define _CHANNEL_RIGHT  2
#define _CHANNEL_ALL    3


class ChannelDevice : public OutputDevice {

  int channel;

 public:

  ChannelDevice();
  ~ChannelDevice();

  char* getNodeName();
  void setChannel(int channel);

  // Note: in a Streambuffer we have the Sender/Source of this buffer piece
  void writeIn(NodeDevice* source,DeviceConfig* buf);


};



#endif
