/*
  starter for plugin decoder
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __DECODERSTARTER_H
#define __DECODERSTARTER_H

#include <amplifier/amplifier.h>
#include <devices/genericPlayer.h>
#include <qwidget.h>
#include <kmsgbox.h>
#include <preferences.h>
#include <song.h>
#include <crashConfig.h>
#include <splayDecoderConfig.h>
#include <mpgDecoderConfig.h>
#include <tplayDecoderConfig.h>
#include <startUpConfig.h>



/**
   This class takes care that it starts the right decoders
   for the given file.
   It encapsulates the generic player calls like open/jump,..
   and forwards it to the correct player. It take care for
   the crashrecovery as well.

*/

class DecoderStarter : public QObject,public NodeDevice {
 Q_OBJECT

 public:
  DecoderStarter();
  ~DecoderStarter();

  char* getNodeName();
  void writeIn(NodeDevice* source,DeviceConfig* buf);

 public slots:

  void open(Song* song,DecoderID* decoderID); 
  void jump(int second);
  void play();
  void pause();
  void stop();

  void setRefCount(int count);
  int getRefCount();
  void configure();

  // internal publics
  bool eventFilter( QObject* object, QEvent *e );

 signals:
  void playNextEvent();
  void openEvent(Song*);

 private slots:
  void makePreferences();
  
  void apply();
  void launchDecoder(Song* target,DecoderID* decoderID); 
  void processEvent(char eventId);
  void decoderCrash();

  DecoderID*  getCurrentDecoderID();
  void restartDecoder(Song* song,int startTime,DecoderID* decoderID);
  void restartSong();

 private:
  DecoderID* getConfigFor(DecoderID* id);
  void setLastSong(Song* song);

  Song* currentSong;
  GenericPlayer* currentDecoder;

  CrashConfig* crashConfig;

  int count;
  int currentTime;
  int defaultDecoderID;
  Preferences* preferences;
  SplayDecoderConfig* splayDecoderConfig;
  MPGDecoderConfig* mpgDecoderConfig;
  int lPlaying;

};
#endif
   


