/*
  ok,apply,cancel box
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include "oacBox.h"



OACBox::OACBox(QWidget * parent=0, const char * name=0 ):QWidget(parent,name) {

  QHBoxLayout *hbox = new QHBoxLayout(this, 5);
  hbox->addSpacing( fontMetrics().height() );


  QPushButton *okButton;
  QPushButton *applyButton;
  QPushButton *cancelButton;

  okButton = new QPushButton( i18n("OK"), this );
  okButton->setFixedSize(okButton->sizeHint());

  applyButton = new QPushButton( i18n("Apply"), this );
  applyButton->setFixedSize(applyButton->sizeHint());

  cancelButton = new QPushButton(i18n("Cancel"), this );
  cancelButton->setFixedSize(cancelButton->sizeHint());

  hbox->addWidget(okButton,0,AlignLeft);
  hbox->addWidget(applyButton,0,AlignLeft);
  hbox->addWidget(cancelButton,0,AlignLeft);

  setFixedSize(QSize(150,30));

  connect(okButton,SIGNAL(clicked()),this,SIGNAL(ok()));
  connect(applyButton,SIGNAL(clicked()),this,SIGNAL(apply()));
  connect(cancelButton,SIGNAL(clicked()),this,SIGNAL(cancel()) );
  
  
  
}


OACBox::~OACBox() {
}
 
