/*
  whole ipc stuff in one class
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */





#ifndef __IPCMODULE_H
#define __IPCMODULE_H

#include <ipc/ipcElement.h>
#include <ipc/ipcCom.h>

#include <sys/stat.h>
#include <sys/file.h>
#include <unistd.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <qstring.h>
#include <qobject.h>
#include <kmpgCommandLine.h>

/**
   The IPC Module handles multiple instances of an application.
   It is quit easy to use. Make an instance with your
   application name of it.
   This sample code checks if it is the first instance if true
   it sends the commandline to the parent.
   <pre>
     IPCModule* ipcModule=new IPCModule("kmpg");
     if (ipcModule->isFirst() == false) {
        ipcModule->send(nargs,args);
        exit(0);
     }
     // only executed if parent
     connect(ipcModule,SIGNAL(processCommandLine(..),this,SLOT(doSome(..)))
   </pre>
*/


class IPCModule: public QObject {
 Q_OBJECT

   int sd;
   char* path;
   int lFirst;
   IPCCom* ipcCom;
   FILE* lockfd;

 public:
  IPCModule(char* appName);
  ~IPCModule();
  
  int isFirst();
  void send(int nargs,char** args);

 public slots:
   void closeIPC();


 signals:
  void processCommandLine(CommandLineCreator* cmdLine);

};
#endif
