/* tagEditor.h

  Created by SMF aka Antoine Laydier (smf@mail.dotcom.fr)

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#ifndef _TAGEDITOR_H_
#define _TAGEDITOR_H_


/**

   Minor changes to the code by Martin Vogt


   - Errors are now handled differently.
   - filedescriptor are not held (see tag.h)
   - removed closeFile method
   - made open private


   No more messageboxes. Messagesboxes would prompt the user
   for each file clicked on the playlist, which comes from
   eg: http sources.
   Suggestion: Let tagEditor record the fileopen state more "silent"
   eg: have a kind of "statusbar" or pixmap in the dialog itsself.
   This is only a ugly (but working) hack

   suggestions: 

   what if the user can do a chown on the permission,
   then a "set" is possible with "override mode 644"

   the pulldown menu could be "searchable" this means, if it is
   open and the mouse in "in it" the user can enter d and it jumps
   to d, etc...


   :-)

*/






/*=============================================================================
  HEADERs
=============================================================================*/
#include <qdialog.h>
#include <qstrlist.h>
#include <qcombo.h>
#include <qpushbt.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qchkbox.h>
#include <iostream.h>

#include "QScrLabel.h"
#include "tag.h"
#include "layer.h"

/*=============================================================================
  CLASSes
=============================================================================*/

/**
 * This is the class TagEditor. The class defines the Dialog that contains
 * the tag editor and the informations
 *
 * @short TabWidget class for Tag Editing
 * @author Antoine Laydier (smf@mail.dotcom.fr)
 * @version 0.6
 *
 */
class TagEditor : public QDialog
{
  Q_OBJECT;
  
 public:

  enum { MENU_ID_RESET=100 , MENU_ID_SET };
  
  /**
   * The constructor method for class TagEditor
   *
   * @see TagEditor
   * @param parent Widget of TagEditor
   * @param name Name of the widget
   * @param sfolder Folder page number to open first
   * @param _list listBox associed to TagEditor
   *
   */
  TagEditor(QWidget *parent = 0, const char *name = 0);

  /**
   * The destrucor method for class TagEditor
   *
   */
  ~TagEditor();

  /**
   * Set the file to edit
   *
   * @param filename Filename of the file to edit
   *
   */
  void setFile(const char * filename);

  /**
   * Set the files to edit
   *
   * @param filenames Filenames of the file to edit (QStrList)
   *
   */
  void setFiles(const QStrList & filenames);

  /**
   * Set the file to edit by giving it position into the list
   * if position is invalid, the position isn't move
   *
   * @param index position to go
   *
   */
  void at ( uint index );

  /**
   * Show the dialog Box for tag editing
   */
  virtual void show ();
    
  // Allow to get TAG information on current file
  char * const getTitle(void)    { return tag->getTitle(); }
  char * const getAlbum(void)    { return tag->getAlbum(); }
  char * const getArtist(void)   { return tag->getArtist(); }
  char * const getYear(void)     { return tag->getYear(); }
  char * const getComment(void)  { return tag->getComment(); }
  char * const getGenre(void)    { return tag->getGenre(); }
  char * const getFilename(void) { return fileList->current(); }

  int hasValidTag();

 // Added by CP 10.10.1998
 signals:

  void tagChanged();

 private:
  
  QPushButton  *bReset, 
               *bSet, 
               *bClose,
               *bNext,
               *bPrev;
  QCheckBox    *CBtitle,
               *CBartist,
               *CBalbum,
               *CByear,
               *CBgenre,
               *CBcomment;
  QComboBox    *cbGenre;
  QLineEdit    *leTitle,
               *leArtist,
               *leAlbum,
               *leComment,
               *leYear;
  // Added by SMF 10/17/98
  QLabel       *lFilename;
  QLabel       *accessLabel;
  QLabel       *accessDesc;
  QScrLabel    *slFilename;

  Tag        * tag;                  // tag informations about current file
  Layer      * layer;                // layer informations about current file
  QStrList   * fileList;             // list of file to edit

  // Added by CP 10.10.1998
  uint	     playIndex;	             // index which is currently played
  int	     hasTag;

  /**
   * Handles all the resizing of the main window of Kmp3te
   *
   * @param all if this is false the widgets won't be resized but the
   * widget will be updated
   *
   */
  virtual void resizeEvent ( QResizeEvent* );

  /**
   * Set all the widgets at theirs places in the TabDialog
   */
  void placeWidgets ( void );

  /**
   * Read tag informations from file
   */
  void Reset ( void );

  /**
   * Set tag informations in file
   */
  int Set ( void );

  /**
   * Read tag informations
   *
   * @param rw Open access to file (read/write)
   */
  void readTag ( bool rw );


public slots:

    /**
     * Handles Next button event
     */
    void bNextActivated ( void );

    /**
     * Handles Prev button event
     */
    void bPrevActivated ( void );

    /**
     * Handles Reset button event
     */
    void bResetActivated ( void );

    /**
     * Handles Set button event
     */
    void bSetActivated ( void );

 private:
  /**
   * Open the selected file in the associed listbox
   */
  int open ( void );

};

#endif 
