/*
  Wrapper for Antoines tagEditor.
  Copyright (C) 1999  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <id/playlistView3.h>


PlaylistView3::PlaylistView3(Playlist* playlist) {
  tagEditor=new TagEditor();
  this->playlist=playlist;
  tag=new Tag();
  layer=new Layer();
  connect(playlist,SIGNAL(setCurrentPosEvent(int)),
	  this,SLOT(setCurrentPosEvent(int)));	
  connect(tagEditor,SIGNAL(tagChanged()),this,SLOT(tagChanged()));
  currentSong=NULL;
}


PlaylistView3::~PlaylistView3() {
  delete tagEditor;
  delete tag;
  delete layer;
}

void PlaylistView3::show() {

  currentSong=playlist->at(playlist->getCurrentPos());
  if (currentSong != NULL) {
    KURL kurl(currentSong->getSongLocation());
    tagEditor->setFile(kurl.path());
    tagEditor->at(0); 
  }
  tagEditor->show();
}


void PlaylistView3::setCurrentPosEvent(int index) {
  const char* location;
  currentSong=playlist->at(index);

  if (currentSong != NULL) {
    location=currentSong->getSongLocation();
    KURL kurl(location);
    if (tagEditor->isVisible()) {
      tagEditor->setFile(kurl.path());
      tagEditor->at(0);
    }
  }
}




void PlaylistView3::tagChanged() {
  if (currentSong != NULL) {
    currentSong->songUpdate();
  }
}
  

