/* Copyright 1997, lvoge@cs.vu.nl */
#include <qstring.h>
#include <qtimer.h>

#include "QScrLabel.h"

QScrLabel::QScrLabel(QWidget* parent=0, const char* name=0, WFlags f=0) : QLabel(parent, name, f) {
	string = new QString;
	timer = new QTimer(this);
	connect(timer, SIGNAL(timeout()), this, SLOT(scroll()));
//	timer->start(500);
	dir = 1;
}

QScrLabel::QScrLabel(const char* text, QWidget* parent=0, const char* name=0, WFlags f = 0) {
	QScrLabel(parent, name, f);
	setLabel(text);
}

void QScrLabel::setLabel(const char *text) {
	timer->stop();
	*string = text;
	maxscroll = string->length();
	while ((maxscroll > 0) &&
	       (fontMetrics().width(text + maxscroll) < (width() - 2 * margin())))
	  maxscroll--;
	if (maxscroll > 0) {
		maxscroll += 3;
		timer->start(500);
	} else setText(text);
}

QScrLabel::~QScrLabel(void) {
	delete string;
	delete timer;
}		

void QScrLabel::scroll() {
	pos += dir;
	if (pos < 0) {
		dir = 1;
		pos = 0;
	} else if (pos > maxscroll) {
		dir = -1;
		pos = maxscroll;
	}
	setText(string->data() + pos);
}

//#include "QScrLabel.moc"
