
#include <stdio.h>

// include files for QT
#include <qdir.h>
#include <qprinter.h>
#include <qpainter.h>
#include <qevent.h>
#include <qlist.h>

#include <qmessagebox.h>
#include <qradiobutton.h>

// include files for KDE
#include <kiconloader.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <kmenubar.h>
#include <klocale.h>
#include <kconfig.h>
#include <kstdaction.h>
#include <kpopupmenu.h>

#include <kprocess.h>

// application specific includes
#include "kmp3db.h"
#include "kmp3dbview.h"
#include "kmp3dbdoc.h"

#include "addmp3dlgimpl.h"
#include "configurationdlgimpl.h"
#include "dbhandling.h"
#include "mp3entry.h"
#include "mp3entrypropertiesdlgimpl.h"


#define ID_STATUS_MSG 1

//Kmp3dbApp::Kmp3dbApp(QWidget *, const char* name):KMainWindow(0, name)
Kmp3dbApp::Kmp3dbApp(QWidget *parent , const char* name):KMainWindow(parent, name)
{
  config=kapp->config();

  ///////////////////////////////////////////////////////////////////
  // call inits to invoke all other construction parts
  initStatusBar();
  initActions();
  initDocument();
  readOptions();
  initView();

// put readOptions above the other init functions, initView() uses mp3Database
//	readOptions();

  ///////////////////////////////////////////////////////////////////
  // disable actions at startup
  //fileSave->setEnabled(false);
  //fileSaveAs->setEnabled(false);
  //filePrint->setEnabled(false);
  //editCut->setEnabled(false);
  //editCopy->setEnabled(false);
  //editPaste->setEnabled(false);
}

Kmp3dbApp::~Kmp3dbApp()
{

}

void Kmp3dbApp::initActions()
{

  fileNewWindow = new KAction(i18n("New &Window"), 0, 0, this, SLOT(slotFileNewWindow()), actionCollection(),"file_new_window");
//  play = new KAction(i18n("&Play"), 0, 0, this, SLOT(play_mp3(QListViewItem*)), actionCollection(),"play");
  play = new KAction(i18n("&Play"), 0, 0, this, SLOT(play_from_menu()), actionCollection(),"play");

  addToPlayList = new KAction(i18n("&Add to players' playlist"), 0, 0, this, SLOT(add_to_playlist_from_menu()/*slotAddToPlayList()*/), actionCollection(),"add_to_playlist");
  deleteFromDB = new KAction(i18n("&Delete"), 0, 0, this, SLOT(slotDeleteFromDB()), actionCollection(),"delete");
  properties = new KAction(i18n("&Properties"), 0, 0, this, SLOT(slotMP3EntryProperties()), actionCollection(),"properties");
  //fileNew = KStdAction::openNew(this, SLOT(slotFileNew()), actionCollection());
  //fileOpen = KStdAction::open(this, SLOT(slotFileOpen()), actionCollection());
  fileOpenRecent = KStdAction::openRecent(this, SLOT(slotFileOpenRecent(const KURL&)), actionCollection());
  //fileSave = KStdAction::save(this, SLOT(slotFileSave()), actionCollection());
  //fileSaveAs = KStdAction::saveAs(this, SLOT(slotFileSaveAs()), actionCollection());
  fileClose = KStdAction::close(this, SLOT(slotFileClose()), actionCollection());
  //filePrint = KStdAction::print(this, SLOT(slotFilePrint()), actionCollection());
  fileQuit = KStdAction::quit(this, SLOT(slotFileQuit()), actionCollection());
  //editCut = KStdAction::cut(this, SLOT(slotEditCut()), actionCollection());
  //editCopy = KStdAction::copy(this, SLOT(slotEditCopy()), actionCollection());
  //editPaste = KStdAction::paste(this, SLOT(slotEditPaste()), actionCollection());

  addMP3 = new KAction(i18n("&Add MP3..."), 0, 0, this, SLOT(slotAddMP3()), actionCollection(),"add_mp3");
  configure = new KAction(i18n("&Configure..."), 0, 0, this, SLOT(slotConfigure()), actionCollection(),"configure");


  viewToolBar = KStdAction::showToolbar(this, SLOT(slotViewToolBar()), actionCollection());
  viewStatusBar = KStdAction::showStatusbar(this, SLOT(slotViewStatusBar()), actionCollection());

  fileNewWindow->setStatusText(i18n("Opens a new application window"));
  //fileNew->setStatusText(i18n("Creates a new document"));
  //fileOpen->setStatusText(i18n("Opens an existing document"));
  //fileOpenRecent->setStatusText(i18n("Opens a recently used file"));
  //fileSave->setStatusText(i18n("Saves the actual document"));
  //fileSaveAs->setStatusText(i18n("Saves the actual document as..."));
  fileClose->setStatusText(i18n("Closes the actual document"));
  //filePrint ->setStatusText(i18n("Prints out the actual document"));
  //fileQuit->setStatusText(i18n("Quits the application"));
  //editCut->setStatusText(i18n("Cuts the selected section and puts it to the clipboard"));
  //editCopy->setStatusText(i18n("Copies the selected section to the clipboard"));
  //editPaste->setStatusText(i18n("Pastes the clipboard contents to actual position"));
  viewToolBar->setStatusText(i18n("Enables/disables the toolbar"));
  viewStatusBar->setStatusText(i18n("Enables/disables the statusbar"));

  // use the absolute path to your kmp3dbui.rc file for testing purpose in createGUI();
//  createGUI("/home/edwin/progs/qt/kmp3db/kmp3db/kmp3dbui.rc");
  createGUI();
}


void Kmp3dbApp::initStatusBar()
{
  ///////////////////////////////////////////////////////////////////
  // STATUSBAR
  // TODO: add your own items you need for displaying current application status.
  statusBar()->insertItem(i18n("Ready."), ID_STATUS_MSG);
}

void Kmp3dbApp::initDocument()
{
  doc = new Kmp3dbDoc(this);
  doc->newDocument();
}

void Kmp3dbApp::initView()
{ 
 QRect r;
	int y=35;
  ////////////////////////////////////////////////////////////////////
  // create the main widget here that is managed by KTMainWindow's view-region and
  // connect the widget to your document to display document contents.

view = new Kmp3dbView(this);
//doc->addView(view);
//setCentralWidget(view);	
//setCaption(doc->URL().fileName(),false);
  resize(480, 600);

// outerframe = new QGroupBox(this);
 outerframe = new QGroupBox(this);

 r.setRect(5,y,350,165);
 outerframe->setGeometry(r);

 y+=10;
 r.setRect(15,y,130,25);
 chkboxfilename = new QCheckBox("Filename", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxfilename->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 filenamecmd = new QLineEdit(this,"filenamepath");
 filenamecmd->setGeometry(r);
 connect(filenamecmd, SIGNAL(returnPressed()), SLOT(searchAndList()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxfilename_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxfilename_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxArtist = new QCheckBox("Artist", this);
 //chkboxArtist->setChecked(TRUE);
 chkboxArtist->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 artistcmd = new QLineEdit(this,"artistpath");
 artistcmd->setGeometry(r);
 connect(artistcmd, SIGNAL(returnPressed()), SLOT(searchAndList()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxArtist_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxArtist_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxTitle = new QCheckBox("Title", this);
 //chkboxTitle->setChecked(TRUE);
 chkboxTitle->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 titlecmd = new QLineEdit(this,"titlepath");
 titlecmd->setGeometry(r);
 connect(titlecmd, SIGNAL(returnPressed()), SLOT(searchAndList()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxTitle_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxTitle_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxAlbum = new QCheckBox("Album", this);
 //chkboxAlbum->setChecked(TRUE);
 chkboxAlbum->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 albumcmd = new QLineEdit(this,"albumpath");
 albumcmd->setGeometry(r);
 connect(albumcmd, SIGNAL(returnPressed()), SLOT(searchAndList()));

 r.moveBy(210,0);r.setWidth(40);
 chkboxAlbum_cs = new QCheckBox("CS", this);
 //chkboxfilename->setChecked(TRUE);
 chkboxAlbum_cs->setGeometry(r);

 y+=30;
 r.setRect(15,y,130,25);
 chkboxCD = new QCheckBox("CD/HD", this);
 //chkboxAlbum->setChecked(TRUE);
 chkboxCD->setGeometry(r);

 r.moveBy(85,0);r.setWidth(200);
 CDcombo = new QComboBox(FALSE, this,"cds");
// QList<CDList> *cdList = new QList<CDList>();

 //cdlist = new QList<CDEntry>();
 fillCDDropDown();
 CDcombo->setGeometry(r);

 QPushButton *ok = new QPushButton(this, "searchbutton");
 ok->setText("Search!");
 //ok->setFocus();
 r.setRect(380,50,80,25);
 ok->setGeometry(r);
 connect(ok, SIGNAL(clicked()), SLOT(searchAndList()));

 ok->setAutoDefault(true);
 if (ok->isDefault()== true)
  printf("isDefault==true !\n");
 else printf("isDefault==false!\n");

 y+=45;
 mp3ListView = new QListView(this);
 r.setRect(5,y,440,150);        //This is no use. resizeEvent() is called
 mp3ListView->setGeometry(r);

 mp3ListView->addColumn("Artist");
 mp3ListView->setColumnWidth(ARTIST_COL, 120);

 mp3ListView->addColumn("Title");
 mp3ListView->setColumnWidth(TITLE_COL, 120);

 mp3ListView->addColumn("Album");
 mp3ListView->setColumnWidth(ALBUM_COL, 120);

 mp3ListView->addColumn("Year");
 mp3ListView->setColumnWidth(YEAR_COL, 40);

 mp3ListView->addColumn("Filename", 2);
 mp3ListView->setColumnWidth(4, 60);
 //mp3list->setColumnWidthMode (4, QListView::Manual);

 mp3ListView->addColumn("CD/HD");
 mp3ListView->setColumnWidth(5, 50);
 mp3ListView->setGeometry(r);
 //mp3list->setMultiSelection(TRUE);
 mp3ListView->setAllColumnsShowFocus(TRUE);
 connect(mp3ListView, SIGNAL(doubleClicked(QListViewItem*)), this, SLOT(play_mp3(QListViewItem *)));
 connect(mp3ListView, SIGNAL(rightButtonClicked(QListViewItem*, const QPoint &, int)),
         this, SLOT(show_menu(QListViewItem*, const QPoint &, int)));
// connect(mp3ListView,SIGNAL(selectionChanged(QListViewItem *)), this, SLOT(update_statusbar(QListViewItem *)));
 connect(mp3ListView, SIGNAL(returnPressed(QListViewItem*)), SLOT(play_mp3(QListViewItem *)));

// // connect(mp3list, SIGNAL(selectionChanged ()), mp3list, SLOT(setFocus ()));

 popup_menu = new KPopupMenu();
 QString tmp = "unkown - unknown";
 popup_menu->insertTitle(tmp, 0);
 popup_menu->insertItem (i18n("play"), this, SLOT(play_from_menu()));
 popup_menu->insertItem (i18n("add to players' playlist"), this, SLOT(add_to_playlist_from_menu()));
 popup_menu->insertSeparator(-1);
 popup_menu->insertItem (i18n("delete"), this, SLOT(slotDeleteFromDB()));
 popup_menu->insertItem (i18n("properties"), this, SLOT(slotMP3EntryProperties()));

// statusbar = new KStatusBar( this );
// char Found[50];
// sprintf(Found, "Found : %-7s", "0");  // 7 digits must be enough
// statusbar->insertItem(Found, 0);
// statusbar->insertItem("File : ", 1);
// setStatusBar( statusbar );

}

void Kmp3dbApp::fillCDDropDown(void) {
	QList<CDEntry> *cdlist;
	DBHandling *db = new DBHandling(mp3Database);

// cdlist->clear();
 CDcombo->clear();
 cdlist = db->buildCDList();
 printf("returned from buildCDList()\n");
 CDEntry *cdentry;

 CDcombo->insertItem("HD"); // also add HD to the list
 for (cdentry = cdlist->first(); cdentry != 0; cdentry=cdlist->next()) {
	printf("adding %s\n", cdentry->CDName.latin1());
  CDcombo->insertItem(cdentry->CDName);
 }

}

void Kmp3dbApp::openDocumentFile(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));

  doc->openDocument( url);
  fileOpenRecent->addURL( url );
  slotStatusMsg(i18n("Ready."));
}


Kmp3dbDoc *Kmp3dbApp::getDocument() const
{
  printf("getDocument\n");
  return doc;
}

void Kmp3dbApp::saveOptions()
{	
  config->setGroup("General Options");
  config->writeEntry("Geometry", size());
  config->writeEntry("Show Toolbar", viewToolBar->isChecked());
  config->writeEntry("Show Statusbar",viewStatusBar->isChecked());
  config->writeEntry("ToolBarPos", (int) toolBar("mainToolBar")->barPos());
  fileOpenRecent->saveEntries(config,"Recent Files");

  config->setGroup( "Player Settings" );
  cdromPath = config->writeEntry("cdrom path", cdromPath);
	mp3Database = config->writeEntry("Database", mp3Database);
	mp3Player = config->writeEntry("mp3player", mp3Player);

}


void Kmp3dbApp::readOptions()
{
  config->setGroup("General Options");

  // bar status settings
  bool bViewToolbar = config->readBoolEntry("Show Toolbar", true);
  viewToolBar->setChecked(bViewToolbar);
  slotViewToolBar();

  bool bViewStatusbar = config->readBoolEntry("Show Statusbar", true);
  viewStatusBar->setChecked(bViewStatusbar);
  slotViewStatusBar();

  // bar position settings
  KToolBar::BarPosition toolBarPos;
  toolBarPos=(KToolBar::BarPosition) config->readNumEntry("ToolBarPos", KToolBar::Top);
  toolBar("mainToolBar")->setBarPos(toolBarPos);

  // initialize the recent file list
	// JES : we are not using this right now
  fileOpenRecent->loadEntries(config,"Recent Files");
  QSize size=config->readSizeEntry("Geometry");
  if(!size.isEmpty())
  {
    resize(size);
  }

  config->setGroup( "Player Settings" );
  cdromPath = config->readEntry("cdrom path", "/cdrom");
	mp3Database = config->readEntry("Database", "mp3.db");
printf("readOptions() : mp3Database=%s\n", mp3Database.latin1());
	mp3Player = config->readEntry("mp3player", "xmms");


printf("leaving readOptions\n");


}

void Kmp3dbApp::saveProperties(KConfig *_cfg)
{
	printf("saveProperties\n");

  if(doc->URL().fileName()!=i18n("Untitled") && !doc->isModified())
  {
    // saving to tempfile not necessary

  }
  else
  {
    KURL url=doc->URL();	
    _cfg->writeEntry("filename", url.url());
    _cfg->writeEntry("modified", doc->isModified());
    QString tempname = kapp->tempSaveName(url.url());
    QString tempurl= KURL::encode_string(tempname);
    KURL _url(tempurl);
    doc->saveDocument(_url);
  }
}


void Kmp3dbApp::readProperties(KConfig* _cfg)
{
  QString filename = _cfg->readEntry("filename", "");
  KURL url(filename);
  bool modified = _cfg->readBoolEntry("modified", false);

	printf("readProperties\n");

  if(modified)
  {
    bool canRecover;
    QString tempname = kapp->checkRecoverFile(filename, canRecover);
    KURL _url(tempname);
  	
    if(canRecover)
    {
      doc->openDocument(_url);
      doc->setModified();
      setCaption(_url.fileName(),true);
      QFile::remove(tempname);
    }
  }
  else
  {
    if(!filename.isEmpty())
    {
      doc->openDocument(url);
      setCaption(url.fileName(),false);
    }
  }
}		

bool Kmp3dbApp::queryClose()
{
	printf("queryClose\n");
  return doc->saveModified();
}

bool Kmp3dbApp::queryExit()
{
  saveOptions();
  return true;
}

/////////////////////////////////////////////////////////////////////
// SLOT IMPLEMENTATION
/////////////////////////////////////////////////////////////////////

void Kmp3dbApp::slotFileNewWindow()
{
  slotStatusMsg(i18n("Opening a new application window..."));
	
  Kmp3dbApp *new_window= new Kmp3dbApp();
  new_window->show();

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileNew()
{
  slotStatusMsg(i18n("Creating new document..."));

  if(!doc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    doc->newDocument();		
    setCaption(doc->URL().fileName(), false);
  }

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileOpen()
{
  slotStatusMsg(i18n("Opening file..."));
	
  if(!doc->saveModified())
  {
     // here saving wasn't successful

  }
  else
  {	
    KURL url=KFileDialog::getOpenURL(QString::null,
        i18n("*|All files"), this, i18n("Open File..."));
    if(!url.isEmpty())
    {
      doc->openDocument(url);
      setCaption(url.fileName(), false);
      fileOpenRecent->addURL( url );
    }
  }
  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileOpenRecent(const KURL& url)
{
  slotStatusMsg(i18n("Opening file..."));
	
  if(!doc->saveModified())
  {
     // here saving wasn't successful
  }
  else
  {
    doc->openDocument(url);
    setCaption(url.fileName(), false);
  }

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileSave()
{
  slotStatusMsg(i18n("Saving file..."));
	
  doc->saveDocument(doc->URL());

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileSaveAs()
{
  slotStatusMsg(i18n("Saving file with a new filename..."));

  KURL url=KFileDialog::getSaveURL(QDir::currentDirPath(),
        i18n("*|All files"), this, i18n("Save as..."));
  if(!url.isEmpty())
  {
    doc->saveDocument(url);
    fileOpenRecent->addURL(url);
    setCaption(url.fileName(),doc->isModified());
  }

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileClose()
{
  slotStatusMsg(i18n("Closing file..."));

  close();

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFilePrint()
{
  slotStatusMsg(i18n("Printing..."));

  QPrinter printer;
  if (printer.setup(this))
  {
    view->print(&printer);
  }

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotFileQuit()
{
  slotStatusMsg(i18n("Exiting..."));
// ???? When I don't call saveOptions, then the options ARE saved ????
//  saveOptions();
  // close the first window, the list makes the next one the first again.
  // This ensures that queryClose() is called on each window to ask for closing
  KMainWindow* w;
  if(memberList)
  {
    for(w=memberList->first(); w!=0; w=memberList->first())
    {
      // only close the window if the closeEvent is accepted. If the user presses Cancel on the saveModified() dialog,
      // the window and the application stay open.
      if(!w->close())
				break;
    }
  }	
  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotEditCut()
{
  slotStatusMsg(i18n("Cutting selection..."));

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotEditCopy()
{
  slotStatusMsg(i18n("Copying selection to clipboard..."));

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotEditPaste()
{
  slotStatusMsg(i18n("Inserting clipboard contents..."));

  slotStatusMsg(i18n("Ready."));
}

// play the MP3
void Kmp3dbApp::slotPlay() {

	printf("playing the mp3\n");
  slotStatusMsg(i18n("playing the mp3."));

}

// Add to playlist
void Kmp3dbApp::slotAddToPlayList() {
	printf("addToPlayList\n");
}

//
// Deletes the selected entry from the database
//
void Kmp3dbApp::slotDeleteFromDB() {
 	//printf("slotDeleteFromDB\n");
 //QMessageBox *pop;
 //pop->information( this, "Delete",
 //                  "Not implemented yet");
 QListViewItem *mp3listitem;// = new QListViewItem(mp3List);
 DBHandling *dbhandling = new DBHandling(mp3Database);
 mp3listitem = mp3ListView->currentItem();

 if ( mp3listitem==NULL) {
   QMessageBox *pop;
   pop->information( this, "Oops",
                   "No song selected.");
   return;
 }
 unsigned int itempos = mp3ListView->itemPos(mp3listitem);
 printf("item position = %d\n", itempos);

 MP3Entry *entry = new MP3Entry();
 entry->Artist = mp3listitem->text(ARTIST_COL);
 entry->Title = mp3listitem->text(TITLE_COL);
 entry->Album = mp3listitem->text(ALBUM_COL);
 entry->Year = mp3listitem->text(YEAR_COL);
 entry->Filename = mp3listitem->text(FN_COL);
 entry->HD_CDTitle = mp3listitem->text(HDCD_COL);
 //entry = dbhandling->dbentrieslist->at(mp3list->childCount()-itempos);
 //printf("itempos=%d, mp3listitem->artist=%s, mp3listitem->title=%s\n", itempos, mp3listitem->text(ARTIST_COL), mp3listitem->text(TITLE_COL));
 //printf("entry->artist=%s, entry->title=%s\n", entry->artist, entry->title);
 // be sure to have the right entry
 //if (strcmp(mp3listitem->text(ARTIST_COL), entry->artist) !=0 ||
 //    strcmp(mp3listitem->text(TITLE_COL), entry->title) !=0) {
 //  printf(" WE HAVE A SYNCHRONISATION PROBLEM HERE (between listview and dblist)\n");
 //  return;
 //}

 dbhandling->deleteFromDB(entry);

 //mp3list->remove(mp3list->currentItem());
 //search(); // update the view
	emit searchAndList();
 delete dbhandling;
}

void Kmp3dbApp::slotMP3EntryProperties() {
	printf("slotProperties\n");
 DBHandling *db = new DBHandling(mp3Database);
 QListViewItem *mp3listitem = new QListViewItem(mp3ListView);
 mp3listitem = mp3ListView->currentItem();

 if ( mp3listitem==NULL) {
   QMessageBox *pop;
   pop->information( this, "Oops",
                   "No song selected.");
   return;
 }

 QFile filename(mp3listitem->text(FN_COL));
 if (! filename.exists() ) {
//   char tmpfilename[255+1];
//   sprintf( tmpfilename, "%s/%s", (const char*)cdrompath, (const char*)filename.name());
   filename.setName(cdromPath + mp3listitem->text(FN_COL));
   if (! filename.exists() ) {
     QMessageBox *pop;
     pop->information( this, "Sorry",
                      "Can't open file.");
     return;
   }
 }

#warning "make an mp3entry here"
//  MP3Entry *mp3entry = new MP3Entry(...);
// MP3EntryPropertiesDlgImpl *dlg = new MP3EntryPropertiesDlgImpl(mp3entry);
  MP3EntryPropertiesDlgImpl *dlg = new MP3EntryPropertiesDlgImpl(mp3listitem->text(FN_COL), mp3listitem->text(ARTIST_COL),
																																	mp3listitem->text(TITLE_COL),mp3listitem->text(ALBUM_COL),
																																	mp3listitem->text(YEAR_COL) );
  if (dlg->exec() == QDialog::Accepted) {
      db->changeEntry(mp3listitem->text(FN_COL), dlg->ArtistLineEdit->text(), dlg->TitleLineEdit->text(),
								dlg->AlbumLineEdit->text(), dlg->YearLineEdit->text());
			// after changing, do a new search.
			searchAndList();

	}

}

void Kmp3dbApp::slotAddMP3() {
	AddMP3dlgImpl *dlg;
  FileHandling *fh = new FileHandling();
  QList<MP3Entry> *mp3list=NULL;// = new QList<MP3Entry>();
	DBHandling *db = new DBHandling(mp3Database);

	dlg = new AddMP3dlgImpl(this, "add_mp3", TRUE);

	if (dlg->exec() == QDialog::Accepted) {
		// pushed the ok button
		// now get a list with mp3's from the specified dir (with the specified config )
    mp3list = fh->searchMP3(dlg->startpath->text(), dlg->recursiveCheckBox->isChecked());
		if (dlg->rereadfromhd->isChecked()) {
			db->deleteFromDB(&dlg->startpath->text());
		}
		db->saveToDatabase(mp3list, dlg->searchonhd->isChecked()?HD:CD);
		//  if (!dlg->CDName.isEmpty())
		//    CDcombo->insertItem((const char*)dlg->CDName);
		printf("you pushed the ok button\n");
	}
	// at this point, we have a list with mp3's. Add it to the database.

	delete fh;
	delete db;
  delete mp3list;
	delete dlg;
}

void Kmp3dbApp::slotConfigure() {
	FILE *fp;
  configurationDlgImpl *dlg = new  configurationDlgImpl(cdromPath, mp3Database, mp3Player, this, "config", TRUE);

  if (dlg->exec() == QDialog::Accepted) {
		cdromPath =  dlg->cdromPath->text();
		mp3Database = dlg->mp3DatabasePath->text();
    mp3Player = dlg->possiblePlayersComboBox->currentText();

    // now let's first make an empty database if not one already exists
		QFile filename(dlg->mp3DatabasePath->text());
		if (! filename.exists() ) {
			fp = fopen(dlg->mp3DatabasePath->text().latin1(), "w");
			fclose(fp);
		}
		
	}
printf("mp3Database = %s\n", mp3Database.latin1());
	delete dlg;
}

void Kmp3dbApp::slotViewToolBar()
{
  slotStatusMsg(i18n("Toggling toolbar..."));
  ///////////////////////////////////////////////////////////////////
  // turn Toolbar on or off
  if(!viewToolBar->isChecked())
  {
    toolBar("mainToolBar")->hide();
  }
  else
  {
    toolBar("mainToolBar")->show();
  }		

  slotStatusMsg(i18n("Ready."));
}

void Kmp3dbApp::slotViewStatusBar()
{
  slotStatusMsg(i18n("Toggle the statusbar..."));
  ///////////////////////////////////////////////////////////////////
  //turn Statusbar on or off
  if(!viewStatusBar->isChecked())
  {
    statusBar()->hide();
  }
  else
  {
    statusBar()->show();
  }

  slotStatusMsg(i18n("Ready."));
}


void Kmp3dbApp::slotStatusMsg(const QString &text)
{
  ///////////////////////////////////////////////////////////////////
  // change status message permanently
  statusBar()->clear();
  statusBar()->changeItem(text, ID_STATUS_MSG);
}

void Kmp3dbApp::searchAndList(void) {
 DBHandling *db = new DBHandling(mp3Database);
 MP3Entry *mp3entry;
	int aantal=0;
	char tmpstr[128];

 mp3ListView->clear();
 if (chkboxfilename->isChecked()) {
   db->getFromDB(filenamecmd->text(), chkboxfilename_cs->isChecked(), Filename);
 }

 if (chkboxArtist->isChecked()) {
  db->getFromDB(artistcmd->text(), chkboxArtist_cs->isChecked(), Artist);
 }

 if (chkboxTitle->isChecked()) {
  db->getFromDB(titlecmd->text(), chkboxTitle_cs->isChecked(), Title);
 }

 if (chkboxAlbum->isChecked()) {
   db->getFromDB(albumcmd->text(), chkboxAlbum_cs->isChecked(), Album);
 }

 if (chkboxCD->isChecked()) {
  db->getFromDB(CDcombo->currentText(), true, cdname);
 }

 // fill mp3ListView
	for (mp3entry=db->MP3List->first(); mp3entry != 0; mp3entry=db->MP3List->next() ) {	
		QListViewItem *item = new QListViewItem(mp3ListView);
	  item->setText(0,(const char*)mp3entry->Artist);
		item->setText(1, (const char*)mp3entry->Title);
		item->setText(2, (const char*)mp3entry->Album);
		item->setText(3, mp3entry->Year);
		item->setText(4, (const char*)mp3entry->Filename);
		item->setText(5, mp3entry->HD_CDTitle);
		aantal++;
		mp3ListView->setCurrentItem(item);
  //mp3list->setColumnWidth(4, 2);
  //mp3list->setColumnWidthMode (4, QListView::Manual);
 }
	sprintf(tmpstr, "Found : %d", aantal);
  slotStatusMsg(tmpstr);


}

void Kmp3dbApp::resizeEvent(QResizeEvent *re) {

  QRect r;
  //printf("Kmp3dbApp::resizeEvent\n");
  re = re; // otherwise the compiler complains
  //size = re->size();
  //printf("width=%d, height=%d\n", width(), height());
  r.setRect(5,205,width()-10,height()-225); // it's terrible to work with all those numbers...but ok it's only my first program.
  //r.setWidth(width()-10);
  mp3ListView->setGeometry(r);

//  setStatusBar( statusbar );
}

void Kmp3dbApp::show_menu(QListViewItem *item, const QPoint &pos, int i) {

	QString titletext;
  i =i;
	if ( item != NULL ) {
		titletext = item->text(0);
		titletext += " - ";
		titletext += item->text(1);
// item = mp3list->currentItem();
 //popup_menu->setTitle(titletext); DEPRECATED
		popup_menu->changeTitle(0, titletext);
		mp3ListView->setSelected(item, TRUE);  // select where the mouse is, otherwise it could be not selected
// mp3list->setCurrentItem(item);
		popup_menu->popup(pos, 0);
 //popup_menu->show();
	}
}

void Kmp3dbApp::play_mp3(QListViewItem *item) {
  KProcess process;
  QString cdname;
  QString arg;
  //QListViewItem *item = mp3list->currentItem ();
  //printf("in play_mp3()\n");
  //printf("text=%s\n", item->text(4)); // item is the row, text(num) is column

  if (strcmp(item->text(5), "HD") != 0) { // if item is not on HD
   arg += cdromPath;
   arg += "/";
  }
  arg+= item->text(4);

  process << mp3Player << arg;
  process.start(KProcess::DontCare);

}

void Kmp3dbApp::play_from_menu(void) {
	emit play_mp3( mp3ListView->currentItem());
}

void Kmp3dbApp::add_to_playlist_from_menu(void) {

 emit add_mp3_to_playlist( mp3ListView->currentItem());
}

void Kmp3dbApp::menu_add_mp3_to_playlist(void) {
 QListViewItem *item = mp3ListView->currentItem ();
 if ( item==NULL) {
   QMessageBox *pop;
   pop->information( this, "Oops",
                   "Please select a song first.");
   return;
 }
 emit add_mp3_to_playlist(item);
}

void Kmp3dbApp::add_mp3_to_playlist(QListViewItem *item) {
  KProcess process;
  QString cdname;
  QString arg;
  //QListViewItem *item = mp3list->currentItem ();
  //printf("in add_mp3()\n");
  //printf("text=%s\n", item->text(4)); // item is the row, text(num) is column
 if ( item==NULL) {
   QMessageBox *pop;
   pop->information( this, "Oops",
                   "No song selected.");
   return;
 }

QString mp3player="xmms";

  if (mp3Player=="xmms") {
   //arg = "-e ";
   if (strcmp(item->text(5), "HD") != 0) { // if item is not on HD
//    arg += cdrompath;
//    arg += "/";
   }
   arg+= item->text(4);
   //printf("player=%s, arg = %s\n", (char*)mp3player, (char*)arg);
   process << mp3Player << "-e" << arg;
//   process << mp3player << "-e" << arg;
   process.start(KProcess::DontCare);
  }
  else {
   QMessageBox *pop;
   pop->information( this, "Sorry",
                   "Currently only supported with xmms");
  }

}




