/***************************************************************************
                          dbhandling.h  -  description
                             -------------------
    begin                : Sat Jan 27 2001
    copyright            : (C) 2001 by Edwin Schepers
    email                : zeus@castel.nl
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#ifndef DBHANDLING_H
#define DBHANDLING_H

#include <stdio.h>

#include <qlist.h>

#include "mp3entry.h"

#define MAXLINELEN	255
#define	SEPARATOR	'|'


enum tMedium { CD, HD };
enum searchType { Filename, Artist, Title, Album, Year, cdname};
/**
  *@author Edwin Schepers
  */

class DBHandling {
public: 
	DBHandling(QString dbfilename);
	DBHandling(const char *dbfilename);
	~DBHandling();

  QList<MP3Entry> *MP3List;
	QList<CDEntry> *CDList;
  void changeEntry(QString filename, QString artist, QString title, QString album, QString year);
  int saveToDatabase(char *Artist, char *Title, char *Album, char *Year);
  QList<MP3Entry> *getFromDB(QString value, bool cs, searchType);
	QList<CDEntry> *buildCDList(void);
  void deleteFromDB(MP3Entry *entry);
	void deleteFromDB(QString *startpath);
  int saveToDatabase(QList<MP3Entry> *, tMedium);

private:
	QString *DBfilename;
  int saveToDatabase(char *filename, char *Artist, char *Title, char *Album, char *Year);
  void deleteHDentries(char *path, bool recursive);
  MP3Entry *getEntry(char *line);
  bool listAvailable;



};







#endif
