/***************************************************************************
                          adddlg.cpp  -  description                              
                             -------------------                                         
    begin                : Mon May 31 1999                                           
    copyright            : (C) 1999 by Edwin Schepers                         
    email                : zeus@castel.nl                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <string.h>

#include <qdialog.h>
#include <qpushbutton.h>
#include <qcheckbox.h>
#include <qlabel.h>
#include <qmessagebox.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qlineedit.h>
#include <qregexp.h>

#include <kapp.h>
#include <klocale.h>

#include "adddlg.h"
#include "confdlg.h"
#include "fnameinfodlg.h"

extern QString cdrompath;
extern QString mp3dbpath;
QString HDsearchPath("/");

AddDlg::AddDlg(QWidget *parent, const char *name)
     : QDialog(parent, name, TRUE)
{
 QRect r;
 int y=10;
 QButtonGroup *bgroup = new QButtonGroup(this);
 //CDName = new QString();
 fnameinfodlg = new FnameInfoDlg(separator, parent, "matchdialog");
 fnameinfodlg->setCaption(i18n("Set Properties"));

 r.setRect(10,y,230,145);
 bgroup->setGeometry(r);
 setFixedSize(250, 350);
 r.setRect(10,y,130,25);
 //chkboxIsCD = new QRadioButton("search on CD", bgroup);
 chkboxIsCD = new QRadioButton(bgroup);
 chkboxIsCD->setText("search on CD");
 chkboxIsCD->setChecked(TRUE);
 chkboxIsCD->setGeometry(r);

 y+=25;
 r.setRect(10,y,130,25);
 //chkboxIsHD = new QRadioButton("search on HD", bgroup);
 chkboxIsHD = new QRadioButton(bgroup);
 chkboxIsHD->setText("search on HD");
 chkboxIsHD->setGeometry(r);

 y+=35;
 r.setRect(40,y,100,25);
 QLabel *startpathLabel = new QLabel("start path:", this,"startpathlabel");
 //startpathLabel->setText("start path:");
 startpathLabel->setGeometry(r);

 dirbrowse = new QPushButton("...", this, "browse");
 r.setRect(200,y+2,30,20);
 dirbrowse->setGeometry(r);
 connect(dirbrowse, SIGNAL(clicked()), this, SLOT(dirBrowse()));

 r.setRect(95,y,100,25);
 startpathcmd = new QLineEdit(this,"hdpath");
 startpathcmd->setText(HDsearchPath);
 startpathcmd->setGeometry(r);

 y+=35;
 r.setRect(40,y,150,25);
 chkboxReread = new QCheckBox("reread from HD", this);
 chkboxReread->setGeometry(r);

 y+=55;
 r.setRect(10,y,200,25);
 chkboxRecursive = new QCheckBox("recursive directory search", this);
 chkboxRecursive->setGeometry(r);

 y+=25;
 r.setRect(10,y,240,25);
 chkboxInfoFromFname = new QCheckBox("Use info from filename", this);
 //chkboxIsRecursiveSearch->setChecked(TRUE);
 chkboxInfoFromFname->setGeometry(r);

 set = new QPushButton("Set...", this, "set");
 r.setRect(170,y,60,20);
 set->setGeometry(r);
 connect(set, SIGNAL(clicked()), SLOT(setMatchProperties()));

 y+=55;
 r.setRect(10,y,240,60);
 QLabel *warnLabel = new QLabel("Do not start your search in the root '/'.\n\
On my redhat system there seems to be\n\
an invisible directory in /dev which \n\
makes the search infinite.", this,"startpathlabel");
 warnLabel->setGeometry(r);

 y = r.bottom() - 15;
 //r. setLeft(
 ok = new QPushButton("Start!", this, "start");
printf("r.x=%d, r.y=%d, r.bottom=%d\n", r.x(),r.y(), r.bottom());
 r.setRect(10,315,80,25);
 ok->setGeometry(r);
 connect(ok, SIGNAL(clicked()), this, SLOT(start_search()));
 ok->setDefault(true);

 cancel = new QPushButton("Cancel", this, "cancel");
 //cancel->setFocus();
 r.moveBy(150,0);
 cancel->setGeometry(r);
 connect(cancel, SIGNAL(clicked()), this, SLOT(reject()));


 strcpy(separator, "-");
}
void AddDlg::dirBrowse() {

/* FnameInfoDlg *dlg;

 dlg = new FnameInfoDlg(this, "matchdialog");
 dlg->setCaption(i18n("Set Properties"));

 if (dlg->exec() == QDialog::Accepted) {
  printf("dlg->exec accepted\n");
 }
 strcpy(separator, dlg->getSeparator());
 delete dlg;
*/
  QMessageBox *pop;
  pop->information( this, "Contents",
                   "Not implemented yet");

}

// start button pushed
void AddDlg::start_search() {
 int retval=-1;

 strcpy(separator, fnameinfodlg->getSeparator());
 ArtistPos = fnameinfodlg->getCurrentItemFromCombo(0);
 AlbumPos = fnameinfodlg->getCurrentItemFromCombo(1);
 printf("separator=%s\n", separator);
 forceFname = fnameinfodlg->forceFname();


 HDsearchPath = startpathcmd->text();
 if (chkboxIsHD->isChecked()) {
   medium=HD;
   if (chkboxReread->isChecked()) {
     printf("re-reading from HD\n");
     if  (chkboxRecursive->isChecked())
       deleteHDentries((char*)startpathcmd->text(), TRUE);
     else
       deleteHDentries((char*)startpathcmd->text(), FALSE);
   }
   retval = searchMP3((char*)startpathcmd->text(), chkboxRecursive->isChecked());
 }
 else {
   medium=CD;
   CDNameDlg = new NameCDDlg(this);
   if (CDNameDlg->exec() == QDialog::Accepted) {
    printf("CDNameDlg accepted\n");
    CDName = CDNameDlg->getCDname();
    retval = searchMP3((char*)cdrompath, chkboxRecursive->isChecked());
    printf("CDNameDlg accepted, CDName=%s\n", (char*)CDName);
    //delete CDNameDlg;
   }
 }
 if (retval == 0)
  accept(); // close the dialog
}

//
// searches in the recursive in 'path' for mp3's. if already an entry in the database, then do nothing
//
int AddDlg::searchMP3(char *path, bool recursive) {
 DIR *dir;
 struct dirent *ent;
 char Artist[MAXCMTLEN+1], Title[MAXCMTLEN+1], Album[MAXCMTLEN+1], Year[5];
 char text1[MAXCMTLEN+1], text2[MAXCMTLEN+1];
 FILE *fileptr;
 char filename[MAXFILELEN+1];
 char complete_path[MAXFILELEN+1];
 char line[1000+1];
 struct stat buff;
 QString tmpmsg;
 //int retval;
 int TagFound;
 //int NrOfFiles;

 //printf("in searchMP3()\n");
 if ((dir=opendir(path))==NULL) {
  tmpmsg = path;
  tmpmsg += " : ";
  tmpmsg += strerror(errno);
  QMessageBox::warning(this, "Error", tmpmsg);
  //QMessageBox::warning(this, "Error", path + ":" + strerror(errno));
  return -1;
 }

 while ((ent=readdir(dir)) != NULL) {
   sprintf(complete_path,"%s/%s", path, ent->d_name);

   if (checkFilename(ent->d_name) == -1) { /* the file is not a mp3 file */
     //printf("the file %s is not mp3\n", ent->d_name);
     stat(complete_path, &buff);
     //printf("S_ISLNK returns %d from %s\n", S_ISLNK(buff.st_mode), complete_path);
     if (S_ISDIR(buff.st_mode) && strcmp(ent->d_name,".") &&
          strcmp(ent->d_name,"..")) {
       //printf("S_ISLNK returns %d\n", S_ISLNK(buff.st_mode));
	     printf("'%s' is a dir\n", complete_path);
       if (recursive)
         searchMP3(complete_path, recursive);
       continue;  // take next 'ent' entry
     }
     else
      continue; // take next 'ent' entry
    }

   sprintf(filename, "%s/%s", path, ent->d_name);
   if ((fileptr=fopen(filename,"r"))==NULL)
   {
    tmpmsg = "unable to open file : ";
    tmpmsg += complete_path;
    QMessageBox::warning(this, "Error", tmpmsg);
    continue;
   }

   fseek(fileptr, -128,SEEK_END);
   TagFound = findTAG(fileptr);

//   chkboxInfoFromFname->isChecked()
   strcpy(Artist, "");
   strcpy(Title,"");
   strcpy(Album,"");
   strcpy(Year,"");

   if (TagFound ) {
     fgets(line, 128, fileptr);
     printf("tag found, complete regel '%s'\n", line);
     strncpy(Title, line, 30);
     Title[30]=0;
     strncpy(Artist, &line[30], 30);
     Artist[30]=0;
     strncpy(Album, &line[2*30], 30);
     Album[30]=0;
     strncpy(Year, &line[3*30], 4);
     Year[4]=0;
     del_trail_spc(Artist);
     del_trail_spc(Title);
     del_trail_spc(Album);
   }
   if ( (chkboxInfoFromFname->isChecked() && forceFname) ||
       (!TagFound && chkboxInfoFromFname->isChecked() )) {
     char RegExp[10];
     printf("determining info from filename\n");
     sprintf( RegExp, ".?%s", separator);
     QRegExp reg(RegExp);
     int len;
     if (reg.isValid()==FALSE) printf("regexp not valid\n");
     int st = reg.match((const char*)ent->d_name, 0, &len);
     printf("pos=%d, patt=%s, len=%d\n", st, reg.pattern(), len);
     if (st != -1) { // if st== -1 then it takes the tag (if present) is this wrong?
       reg.setWildcard (TRUE);
       printf("ent->dname=%s\n", ent->d_name);
       strncpy(text1, (char*)ent->d_name, st+1);
       text1[st+1]=0;
       int copylen = strlen(ent->d_name) - st/*len of first item*/ - strlen(separator) - 4/* .mp3*/;
       strncpy(text2,  (char*)&ent->d_name[st+strlen(separator)+1],
               copylen);
       text2[copylen-1]=0;
       //printf("text1='%s', text2='%s'\n", text1, text2);
       if (ArtistPos == 0) {
         strcpy( Artist, text1);
         strcpy(Title, text2);
       }
       else {
         strcpy(Title, text1);
         strcpy(Artist, text2);
       }
     }
   }
   //printf("Artist='%s', Title='%s', Album='%s'\n", Artist, Title, Album);
   saveToDatabase(filename, Artist, Title, Album, Year);
   //update(); // does it do what I want it to do?
   fclose(fileptr); // close mp3 file

 }
 closedir(dir);
 return 0;
}

int AddDlg::findTAG(FILE *fileptr)
{
 int i=0;

 while ((i=fgetc(fileptr))!=EOF)
 {
  if (i=='T')
    if ((i=fgetc(fileptr))=='A')
      if ((i=fgetc(fileptr))=='G') {
//        printf("TAG found!\n");
        return 1;
      }
 }
 return 0;
}

void AddDlg::del_trail_spc(char *name)
{
 int i;

 i=strlen(name)-1;
 while (name[i] == ' ' ) {
  name[i--] = 0;
 }
}

int AddDlg::checkFilename(char *fname)
{
 if (strlen(fname)<4) return -1;
 if ( strstr(&fname[strlen(fname)-4], ".mp3") ||
      strstr(&fname[strlen(fname)-4], ".MP3")) {
  return 0;
 }
 return -1;
}

int AddDlg::saveToDatabase(char *location, char *Artist, char *Title, char *Album, char *Year) {

 FILE *fileptr;
 QString tmpmsg;
 char line[255+1];
 int isAlready=0;
 char lineToWrite[255+1];

 switch (medium) {
  case HD:
   sprintf(lineToWrite, "HD%c%s%c%s%c%s%c%s%c%s", SEPARATOR, location,
           SEPARATOR, Artist, SEPARATOR, Title, SEPARATOR, Album, SEPARATOR, Year);
   break;
  case CD:
   printf("cdrompath=%s\n", (const char*)cdrompath);
   sprintf(lineToWrite, "<%s>%c%s%c%s%c%s%c%s%c%s", CDNameDlg->getCDname(), SEPARATOR,
           &location[cdrompath.length()+1], SEPARATOR, Artist,
           SEPARATOR, Title, SEPARATOR, Album, SEPARATOR, Year);
 }
 //printf("AddDlg::saveToDatabase : line to write '%s'\n", lineToWrite);
 if ((fileptr=fopen(mp3dbpath,"a+"))==NULL) {
    tmpmsg = "unable to open databse : ";
    tmpmsg += mp3dbpath;
    tmpmsg += "\n\n";
    tmpmsg += strerror(errno);
    QMessageBox::warning(this, "Error", tmpmsg);
    return -1;
 }
 rewind(fileptr);
 while ( fgets(line, 255,fileptr) != NULL ) {
  if (strstr(line,lineToWrite)) {
     isAlready=1;
     //printf("%s already in the database\n",location);
     break;
  }
 }
 fclose(fileptr);

 if ((fileptr=fopen(mp3dbpath,"a+"))==NULL) {
    tmpmsg = "unable to open databse : ";
    tmpmsg += mp3dbpath;
    tmpmsg += "\n\n";
    tmpmsg += strerror(errno);
    QMessageBox::warning(this, "Error", tmpmsg);
    return -1;
 }
 if (!isAlready) {
   printf(" new mp3 : %s\n", lineToWrite);
   fprintf(fileptr, "%s\n", lineToWrite);
 }

 fclose(fileptr);
 return 0;
}

void AddDlg::deleteHDentries(char *path , bool recursive) {
 FILE *newfileptr;
 FILE *oldfileptr;
 char line[255+1];
 char tmpfile[MAXFILELEN+1];
 QString tmpmsg;
 char searchline[255+1];
 char *filename_col;
 char delim[10];
 char *line2;
 int fileInDir=0;

 sprintf(delim, "%c", SEPARATOR);
 if ((oldfileptr=fopen(mp3dbpath,"r"))==NULL) {
      tmpmsg = "unable to open file : ";
      tmpmsg += mp3dbpath;
      //QMessageBox::warning(this, "Error", (const char*)tmpmsg);
  		return;
 }

 sprintf(tmpfile, "%s.%d", (const char*)mp3dbpath, getpid());
 if ((newfileptr=fopen(tmpfile,"w"))==NULL) {
      tmpmsg = "unable to open file : ";
      tmpmsg += tmpfile;
      //QMessageBox::warning(this, "Error", (const char*)tmpmsg);
  		return;
 }

 if ( path[strlen(path)-1] == '/')
   path[strlen(path)-1] = 0; // delete trailing slash

 sprintf(searchline, "HD%c%s", SEPARATOR, path);
 while (fgets(line, MAXLINELEN, oldfileptr) != NULL) {
   line2 = strdup(line);
   strtok(line2, delim); // HD or CD
   filename_col = strtok(NULL, delim);
   fileInDir=0;
   if ( strlen(path) < strlen(filename_col) ) {
     //printf("finding / in %s\n", &filename_col[strlen(path)+1]);
     if ( strstr(&filename_col[strlen(path)+1], "/") == NULL ) {// filename_col-path is only a (part of a) filename
       fileInDir = 1;
       //printf("%s could get deleted\n", filename_col);
     }
   }

   if ( recursive || fileInDir) {
     if (strncmp(line, searchline, strlen(searchline)) == 0) { // if equal
       // delete this line
       printf("deleting line '%s'\n", line);
     }
     else {
       fprintf(newfileptr, line);
       //printf("copying(1) %s to new db\n", line);
     }
   }
   else {
     fprintf(newfileptr, line);
     //printf("copying(2) %s to new db\n", line);
   }
 }

 fclose(oldfileptr);
 fclose(newfileptr);
 unlink((const char*)mp3dbpath);					// delete old databasse
 rename(tmpfile,(const char*)mp3dbpath);  // rename new database

}

void AddDlg::setMatchProperties(void) {

 //AlbumPos = -1;
 //ArtistPos = -1;

 //dlg = new FnameInfoDlg(separator, this, "matchdialog");
 //dlg->setCaption(i18n("Set Properties"));

 if (fnameinfodlg->exec() == QDialog::Accepted) {
  printf("dlg->exec accepted\n");
  //strcpy(separator, fnameinfodlg->getSeparator());
  //ArtistPos = fnameinfodlg->getCurrentItemFromCombo(0);
  //AlbumPos = fnameinfodlg->getCurrentItemFromCombo(1);
 }

//printf("separator=%s\n", separator);
 //forceFname = fnameinfodlg->forceFname();


}
AddDlg::~AddDlg() {
 delete fnameinfodlg;
}

NameCDDlg::NameCDDlg( QWidget *parent, const char *name) :
   QDialog(parent,name,true) {

  QRect r, br;
  QLabel *label;
  QPushButton *button;

  setFixedSize(200,100);

  //name->setText("hallo");
  //name->selectAll();
  label = new QLabel(this, "cdtitle");
  label->setText("CD title :");
  r.setRect(5,5,50,25);
  label->setGeometry(r);

  cdname = new QLineEdit(this,"cdname");
  r.setRect(60,5,100,25);
  cdname->setGeometry(r);

  r.moveBy(0,25);
  button = new QPushButton(i18n("&OK"),this);
  button->setDefault(true);
  br.setRect(5,r.bottom() + 10,60,25);
  button->setGeometry(br);
  connect(button,SIGNAL(clicked()),this,SLOT(accept()));

  button = new QPushButton(i18n("Cancel"),this);
  br.moveBy(r.right() - br.right(),0);
  button->setGeometry(br);
  connect(button,SIGNAL(clicked()),this,SLOT(reject()));

  //setFixedSize(r.x()*2 + r.width(),br.bottom() + 5);

  cdname->setFocus();
}

NameCDDlg::~NameCDDlg(void) {

}


const char* NameCDDlg::getCDname(void) {
 return cdname->text();
}








































































































































