/*
 *	      LCDWidget - LCD display widget for kmikmod
 *	(C)1998, 1999 Roope Anttinen - roope.anttinen@ntc.nokia.com
 *	
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 */

#include "LCDWidget.h"
#include <stdio.h>

LCDWidget::LCDWidget ( QWidget *parent, const char *name )
: QFrame (parent, name)
{
	X=Y=W=H=lenght=0;
	foreg=red;
	backg=black;
	offg="dark red";
}

LCDWidget::~LCDWidget()
{
	for (int i=0; i<lenght; i++) delete led_array[i];
}

void LCDWidget::setGeometry (int x, int y, int w, int h)
{
	QWidget::setGeometry (x, y, w, h);
	(h < 50) ? setSmallLEDS (true): setSmallLEDS (false);
	X=x;
	Y=y;
	W=w;
	H=h;
}

void LCDWidget::display (const int value)
{
	char tmp [11];
	sprintf (tmp, "%3i", value);
	for (int i=0; i<lenght; i++) led_array[i]->display(tmp[i]);
}

void LCDWidget::display (const char *value)
{
	for (int i=0; i<lenght; i++) led_array[i]->display(value[i]);
}

bool LCDWidget::setNumDigits (const int value)
{
	if (value > LCD_MAX_LEN) return false;
	lenght = value;
	for (int i=0; i<lenght; i++) {
		led_array[i] = new BW_LED_Number(this);
		led_array[i]->setGeometry ((lenght-i)+(i*W/lenght), Y,
					     (W/lenght), H);
		led_array[i]->display(' ');
	}
	(H < 50) ? setSmallLEDS (true): setSmallLEDS (false);
	return true;
}

void LCDWidget::setSmallLEDS (const bool enabled)
{
	for (int i=0; i<lenght; i++) led_array[i]->setSmallLED (enabled);
	setColors (foreg, backg, offg);
}

void LCDWidget::setColors (QColor fg, QColor bg, QColor off)
{
	foreg = fg;
	backg = bg;
	offg = off;
	for (int i=0; i<lenght; i++) {
		led_array[i]->setLEDColor(foreg, backg);
		led_array[i]->setLEDoffColor(offg);
	}
	setBackgroundColor ( backg );
}
