
/*
  process Messages on the decoder
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */




#ifndef __INPUTDECODER_H
#define __INPUTDECODER_H
#include <pthread.h>

#include <yafcore/outputInterface.h>
#include <yafcore/commandTable.h>
#include <yafcore/commandTableYAF.h>
#include <yafcore/yafRuntime.defs>
#include <yafcore/commandLine.h>
#include <yafcore/buffer.h>


extern "C" {
#include <yafcore/streamWriter.h>
	   }

#include <fstream.h>



#define _DECODER_STATUS_IDLE       1
#define _DECODER_STATUS_WORKING    2
#define _DECODER_STATUS_EXIT       3

class InputDecoder {

  int status;
  CommandTable commandTable;
  CommandTableYAF* yafCommands;
  Buffer* returnBuffer;
  Buffer* returnLine;
  int lRuntimeInfo;



  
 public:
  InputDecoder();
  virtual ~InputDecoder();
  
  void processCommandLine(CommandLine*);
  virtual char* processCommand(int command,char* args);
  virtual void doSomething();

  virtual void setDecoderStatus(int status);
  int getDecoderStatus();

  char* getReturnCode();

  void appendCommandTable(CommandTable* table);

  void setRuntimeInfo(int lRuntimeInfo);
  int getRuntimeInfo();


 private:

  void clearReturnBuffer();
  void appendReturnBuffer(char* msg);


  int commandCounter;
  int commandId;
  char* commandMsg;
  char* commandArgs;
  char* retString;
  char* commandCounterString;
  
  
};

#endif

