/*
  stores Nodedevices
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */



#ifndef _EDGES_H
#define _EDGES_H

#include <devices/nodeDevice.h>

#define _EDGES_MAX 20


/**
 Edges are a significat speedup for the traversal
 in the tree. Every nodeDevice stores its own
 Edges structure for the listeners. This class
 can be seen as a cache for yafGraph class.
 If the edges class was not here the nodeDevice would 
 have to query each time the yafGraph class for
 the listeners to serve. nodeDevices keep
 this edges structure up to date. It works 
 automatically.
 
*/

class Edges {

  int elements;
  struct NodeDevice* nodeDeviceArray[_EDGES_MAX];
  
 public:

  Edges();
  ~Edges();

  int getElements();
  void setElements(int elements);
  void clear();

  struct NodeDevice* getNodeDevice(int element);
  void setNodeDevice(int pos,struct NodeDevice* nodeDevice);

};


#endif
