/*
  stores Nodedevices
  Copyright (C) 1998  Martin Vogt

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation.

  For more information look at the file COPYRIGHT in this package

 */


#include <graph/edges.h>
#include "../../../../config.h"



Edges::Edges() {
  elements=0;
}


Edges::~Edges() {
}



int Edges::getElements() {
  return elements;
}

void Edges::setElements(int elements) {
  this->elements=elements;
}


void Edges::clear() {
  elements=0;
}


NodeDevice* Edges::getNodeDevice(int element) {
  if (element >= _EDGES_MAX) {
    debugOutput( cout << "Access out of maximum edges: Edges::getNodeDevice"<<endl );
    exit(1);
  }
  return nodeDeviceArray[element];
}


void Edges::setNodeDevice(int pos,NodeDevice* nodeDevice) {
  if (pos >= _EDGES_MAX) {
    debugOutput( cout << "Access out of maximum edges: Edges::setNodeDevice"<<endl );
    exit(1);
  }
  nodeDeviceArray[pos]=nodeDevice;
}


